package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.AuditStatus;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.WorksInfo;
import com.jz.jooq.media.tables.pojos.WorksTheme;

@Lazy
@Repository
public class WorksThemeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.WorksTheme WT = Tables.WORKS_THEME;
	private static final com.jz.jooq.media.tables.WorksThemeRelation TR = Tables.WORKS_THEME_RELATION;
	private static final com.jz.jooq.media.tables.WorksInfo WI = Tables.WORKS_INFO;

	/********************************************************************/
	/**************************** works theme ***************************/
	/********************************************************************/

	public List<WorksTheme> findSimpleOnlineTheme() {
		return mediaCtx.select(WT.ID, WT.SEQ, WT.LAST_UPDATED).from(WT)
				.where(WT.STATUS.eq(AuditStatus.online.getCode())).fetchInto(WorksTheme.class);
	}

	public int countOnlineTheme() {
		return mediaCtx.fetchCount(WT, WT.STATUS.eq(AuditStatus.online.getCode()));
	}

	public List<String> findOnlineThemeIds(int start, int size) {
		return mediaCtx.select(WT.ID).from(WT).where(WT.STATUS.eq(AuditStatus.online.getCode()))
				.orderBy(WT.SEQ.desc(), WT.LAST_UPDATED.desc()).limit(start, size).fetchInto(String.class);
	}

	public List<WorksTheme> findThemeInfo(Collection<String> tids) {
		return mediaCtx.selectFrom(WT).where(WT.ID.in(tids)).fetchInto(WorksTheme.class);
	}

	/********************************************************************/
	/************************** works relation **************************/
	/********************************************************************/

	public List<String> filterRevealableThemeIds(Collection<String> tids) {
		return mediaCtx.selectDistinct(TR.THEME_ID).from(TR.join(WI).on(TR.WORK_ID.eq(WI.ID)))
				.where(TR.THEME_ID.in(tids).and(WI.IS_OPEN.ge(1)).and(WI.STATUS.eq(AuditStatus.online.getCode())))
				.fetchInto(String.class);
	}
}
