package com.jz.jar.media.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class UserSignAppRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserSignApp USA = Tables.USER_SIGN_APP;

	public void refreshSignApp(String uid, BrandEnum brand) {
		long timeMillis = System.currentTimeMillis();
		mediaCtx.insertInto(USA, USA.PUID, USA.APP, USA.LAST_TIME, USA.CREATE_TIME)
				.values(uid, brand.name(), timeMillis, timeMillis).onDuplicateKeyUpdate().set(USA.LAST_TIME, timeMillis)
				.execute();
	}

}
