package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.ReservationRepository;
import com.jz.jooq.media.tables.records.ReservationRecord;

@Lazy
@Service
public class ReservationService {

	@Autowired
	private ReservationRepository reservationRepository;

	public void saveRecord(ReservationRecord record) {
		reservationRepository.saveRecord(record);
	}

	/** 是否存在有效的预约 */
	public boolean existValidReservation(String uid, String schoolId) {
		return reservationRepository.existValidReservation(uid, schoolId);
	}

	/** 是否存在预约 */
	public boolean existReservation(String uid) {
		return reservationRepository.existReservation(uid);
	}

	public int countValidReservation(BrandEnum brand, String uid) {
		return reservationRepository.countValidReservation(brand, uid);
	}

	public List<String> getReservationSchools(BrandEnum brand, String uid) {
		return reservationRepository.getReservationSchools(brand, uid);
	}
}
