/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.AuditStatus;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.TomatoTheme;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class TomatoThemeRepository
extends MediaBaseRepository {
    private static final TomatoTheme THEME = Tables.TOMATO_THEME;

    public List<String> findAllOnlineThemeIds() {
        return this.mediaCtx.select((SelectField)TomatoThemeRepository.THEME.ID).from((TableLike)THEME).where(new Condition[]{TomatoThemeRepository.THEME.STATUS.eq((Object)AuditStatus.online.getCode())}).fetchInto(String.class);
    }

    private Condition getHomeCondition() {
        return TomatoThemeRepository.THEME.STATUS.eq((Object)AuditStatus.online.getCode()).and(TomatoThemeRepository.THEME.HOME_SHOW.eq((Object)1));
    }

    public int countOnlineHomeShowThemes() {
        return this.mediaCtx.fetchCount((Table)THEME, this.getHomeCondition());
    }

    public List<com.jz.jooq.media.tables.pojos.TomatoTheme> findOnlineHomeShowThemes(int start, int size) {
        return this.mediaCtx.select((SelectField)TomatoThemeRepository.THEME.ID, (SelectField)TomatoThemeRepository.THEME.NAME, (SelectField)TomatoThemeRepository.THEME.BANNER_PIC).from((TableLike)THEME).where(new Condition[]{this.getHomeCondition()}).orderBy(TomatoThemeRepository.THEME.SCORE.desc()).limit(start, size).fetchInto(com.jz.jooq.media.tables.pojos.TomatoTheme.class);
    }

    public boolean isOnlineTheme(String id) {
        return this.mediaCtx.fetchExists((Table)THEME, TomatoThemeRepository.THEME.ID.eq((Object)id).and(TomatoThemeRepository.THEME.STATUS.eq((Object)AuditStatus.online.getCode())));
    }
}

