package com.jz.jar.media.repository;

import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.AuditStatus;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoTheme;

@Lazy
@Repository
public class TomatoThemeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoTheme THEME = Tables.TOMATO_THEME;

	public List<String> findAllOnlineThemeIds() {
		return mediaCtx.select(THEME.ID).from(THEME).where(THEME.STATUS.eq(AuditStatus.online.getCode()))
				.fetchInto(String.class);
	}

	private Condition getHomeCondition() {
		return THEME.STATUS.eq(AuditStatus.online.getCode()).and(THEME.HOME_SHOW.eq(1));
	}

	public int countOnlineHomeShowThemes() {
		return mediaCtx.fetchCount(THEME, getHomeCondition());
	}

	public List<TomatoTheme> findOnlineHomeShowThemes(int start, int size) {
		return mediaCtx.select(THEME.ID, THEME.NAME, THEME.BANNER_PIC).from(THEME).where(getHomeCondition())
				.orderBy(THEME.SCORE.desc()).limit(start, size).fetchInto(TomatoTheme.class);
	}

	public boolean isOnlineTheme(String id) {
		return mediaCtx.fetchExists(THEME, THEME.ID.eq(id).and(THEME.STATUS.eq(AuditStatus.online.getCode())));
	}
}
