/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.AuditStatus;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.TomatoTheme;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class TomatoThemeRepository
extends MediaBaseRepository {
    private static final TomatoTheme THEME = Tables.TOMATO_THEME;

    public List<String> findAllOnlineThemeIds() {
        return this.mediaCtx.select((SelectField)TomatoThemeRepository.THEME.ID).from((TableLike)THEME).where(new Condition[]{TomatoThemeRepository.THEME.STATUS.eq((Object)AuditStatus.online.getCode())}).fetchInto(String.class);
    }

    public int countOnlineThemes() {
        return this.mediaCtx.fetchCount((Table)THEME, TomatoThemeRepository.THEME.STATUS.eq((Object)AuditStatus.online.getCode()));
    }

    public List<com.jz.jooq.media.tables.pojos.TomatoTheme> findOnlineThemes(int start, int size) {
        return this.mediaCtx.select((SelectField)TomatoThemeRepository.THEME.ID, (SelectField)TomatoThemeRepository.THEME.NAME, (SelectField)TomatoThemeRepository.THEME.BANNER_PIC).from((TableLike)THEME).where(new Condition[]{TomatoThemeRepository.THEME.STATUS.eq((Object)AuditStatus.online.getCode())}).orderBy(TomatoThemeRepository.THEME.SCORE.desc()).limit(start, size).fetchInto(com.jz.jooq.media.tables.pojos.TomatoTheme.class);
    }

    public boolean isOnlineTheme(String id) {
        return this.mediaCtx.fetchExists((Table)THEME, TomatoThemeRepository.THEME.ID.eq((Object)id).and(TomatoThemeRepository.THEME.STATUS.eq((Object)AuditStatus.online.getCode())));
    }
}

