/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.FansRelation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class FansRelationRepository
extends MediaBaseRepository {
    private static final FansRelation FR = Tables.FANS_RELATION;

    public void addFansRelation(BrandEnum brand, String puid, String fuid) {
        this.mediaCtx.insertInto((Table)FR, (Field)FansRelationRepository.FR.BRAND, (Field)FansRelationRepository.FR.PUID, (Field)FansRelationRepository.FR.FUID, (Field)FansRelationRepository.FR.CREATE_TIME).values((Object)brand.name(), (Object)puid, (Object)fuid, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public void deleteMyFollow(BrandEnum brand, String puid, String fuid) {
        this.mediaCtx.deleteFrom((Table)FR).where(new Condition[]{FansRelationRepository.FR.BRAND.eq((Object)brand.name()).and(FansRelationRepository.FR.PUID.eq((Object)puid)).and(FansRelationRepository.FR.FUID.eq((Object)fuid))}).execute();
    }

    public int countMyFans(BrandEnum brand, String puid) {
        return this.mediaCtx.fetchCount((Table)FR, FansRelationRepository.FR.BRAND.eq((Object)brand.name()).and(FansRelationRepository.FR.PUID.eq((Object)puid)));
    }

    public List<String> getMyFans(BrandEnum brand, String puid, int start, int size) {
        return this.mediaCtx.select((SelectField)FansRelationRepository.FR.FUID).from((TableLike)FR).where(new Condition[]{FansRelationRepository.FR.BRAND.eq((Object)brand.name()).and(FansRelationRepository.FR.PUID.eq((Object)puid))}).orderBy(FansRelationRepository.FR.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public int countMyFollow(BrandEnum brand, String fuid) {
        return this.mediaCtx.fetchCount((Table)FR, FansRelationRepository.FR.BRAND.eq((Object)brand.name()).and(FansRelationRepository.FR.FUID.eq((Object)fuid)));
    }

    public List<String> getMyFollow(BrandEnum brand, String fuid) {
        return this.mediaCtx.select((SelectField)FansRelationRepository.FR.PUID).from((TableLike)FR).where(new Condition[]{FansRelationRepository.FR.BRAND.eq((Object)brand.name()).and(FansRelationRepository.FR.FUID.eq((Object)fuid))}).fetchInto(String.class);
    }

    public List<String> getMyFollow(BrandEnum brand, String fuid, int start, int size) {
        return this.mediaCtx.select((SelectField)FansRelationRepository.FR.PUID).from((TableLike)FR).where(new Condition[]{FansRelationRepository.FR.BRAND.eq((Object)brand.name()).and(FansRelationRepository.FR.FUID.eq((Object)fuid))}).orderBy(FansRelationRepository.FR.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public Pair<Integer, Integer> getRelationCnt(BrandEnum brand, String uid) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(1) AS pc, t1.* FROM `fans_relation` t0,");
        sb.append(" (SELECT COUNT(1) AS fc FROM `fans_relation` WHERE `brand` = :brand AND `fuid` = :uid) t1");
        sb.append(" WHERE t0.`brand` = :brand AND t0.`puid` = :uid");
        HashMap params = Maps.newHashMap();
        params.put("brand", brand.name());
        params.put("uid", uid);
        Map map = this.mediaNamedParameterJdbcTemplate.queryForMap(sb.toString(), (Map)params);
        if (ArrayMapTools.isEmpty((Map)map)) {
            return Pair.of((Object)0, (Object)0);
        }
        return Pair.of((Object)MapUtils.getIntValue((Map)map, (Object)"pc"), (Object)MapUtils.getIntValue((Map)map, (Object)"fc"));
    }

    public List<String> screenMyFollow(BrandEnum brand, String fuid, Collection<String> puids) {
        return this.mediaCtx.select((SelectField)FansRelationRepository.FR.PUID).from((TableLike)FR).where(new Condition[]{FansRelationRepository.FR.BRAND.eq((Object)brand.name()).and(FansRelationRepository.FR.PUID.in(puids)).and(FansRelationRepository.FR.FUID.eq((Object)fuid))}).fetchInto(String.class);
    }

    public boolean isMyFollow(BrandEnum brand, String puid, String fuid) {
        return this.mediaCtx.fetchExists((Table)FR, FansRelationRepository.FR.BRAND.eq((Object)brand.name()).and(FansRelationRepository.FR.PUID.eq((Object)puid)).and(FansRelationRepository.FR.FUID.eq((Object)fuid)));
    }
}

