/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Lists;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.StudentPlayMonthAttrTotal;
import com.jz.jooq.media.tables.StudentPlayMonthTotal;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class StudentPlayMonthTotalRepository
extends MediaBaseRepository {
    private static final StudentPlayMonthTotal MONTH = Tables.STUDENT_PLAY_MONTH_TOTAL;
    private static final StudentPlayMonthAttrTotal AT = Tables.STUDENT_PLAY_MONTH_ATTR_TOTAL;

    public void refreshPlayTotal(BrandEnum brand, String suid, String month, int playTime, int videoCnt) {
        long timeMillis = System.currentTimeMillis();
        this.mediaCtx.insertInto((Table)MONTH, (Field)StudentPlayMonthTotalRepository.MONTH.BRAND, (Field)StudentPlayMonthTotalRepository.MONTH.SUID, (Field)StudentPlayMonthTotalRepository.MONTH.MONTH, (Field)StudentPlayMonthTotalRepository.MONTH.PLAY_TIME, (Field)StudentPlayMonthTotalRepository.MONTH.VIDEO_CNT, (Field)StudentPlayMonthTotalRepository.MONTH.CREATE_TIME, (Field)StudentPlayMonthTotalRepository.MONTH.LAST_UPDATE).values((Object)brand.name(), (Object)suid, (Object)month, (Object)playTime, (Object)videoCnt, (Object)timeMillis, (Object)timeMillis).onDuplicateKeyUpdate().set((Field)StudentPlayMonthTotalRepository.MONTH.PLAY_TIME, StudentPlayMonthTotalRepository.MONTH.PLAY_TIME.add((Number)playTime)).set((Field)StudentPlayMonthTotalRepository.MONTH.VIDEO_CNT, StudentPlayMonthTotalRepository.MONTH.VIDEO_CNT.add((Number)videoCnt)).set((Field)StudentPlayMonthTotalRepository.MONTH.LAST_UPDATE, (Object)timeMillis).execute();
    }

    public void refreshAttrsPlayTotal(BrandEnum brand, String suid, String month, List<String> attrs, int playTime, int videoCnt) {
        long timeMillis = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO `student_play_month_attr_total` ");
        sb.append("(`brand`, `suid`, `attr_id`, `month`, `play_time`, `video_cnt`, `create_time`, `last_update`)");
        sb.append(" VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        sb.append("ON DUPLICATE KEY UPDATE `play_time` = `play_time` + ?, `video_cnt` = `video_cnt` + ?, `last_update` = ?");
        ArrayList batchArgs = Lists.newArrayList();
        for (String atr : attrs) {
            batchArgs.add(new Object[]{brand.name(), suid, atr, month, playTime, videoCnt, timeMillis, timeMillis, playTime, videoCnt, timeMillis});
        }
        this.mediaJdbcTemplate.batchUpdate(sb.toString(), (List)batchArgs);
    }

    public com.jz.jooq.media.tables.pojos.StudentPlayMonthTotal getPlayTotal(BrandEnum brand, String suid, String month) {
        return (com.jz.jooq.media.tables.pojos.StudentPlayMonthTotal)this.mediaCtx.selectFrom((Table)MONTH).where(new Condition[]{StudentPlayMonthTotalRepository.MONTH.BRAND.eq((Object)brand.name()).and(StudentPlayMonthTotalRepository.MONTH.SUID.eq((Object)suid)).and(StudentPlayMonthTotalRepository.MONTH.MONTH.eq((Object)month))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.StudentPlayMonthTotal.class);
    }

    public int countGePlayTime(BrandEnum brand, String month, int playTime) {
        return this.mediaCtx.fetchCount((Table)MONTH, StudentPlayMonthTotalRepository.MONTH.BRAND.eq((Object)brand.name()).and(StudentPlayMonthTotalRepository.MONTH.MONTH.eq((Object)month)).and(StudentPlayMonthTotalRepository.MONTH.PLAY_TIME.ge((Object)playTime)));
    }

    public com.jz.jooq.media.tables.pojos.StudentPlayMonthAttrTotal getMaxAttrPlayTotal(BrandEnum brand, String suid, String month) {
        return (com.jz.jooq.media.tables.pojos.StudentPlayMonthAttrTotal)this.mediaCtx.selectFrom((Table)AT).where(new Condition[]{StudentPlayMonthTotalRepository.AT.BRAND.eq((Object)brand.name()).and(StudentPlayMonthTotalRepository.AT.SUID.eq((Object)suid)).and(StudentPlayMonthTotalRepository.AT.MONTH.eq((Object)month))}).orderBy(StudentPlayMonthTotalRepository.AT.PLAY_TIME.desc()).fetchAnyInto(com.jz.jooq.media.tables.pojos.StudentPlayMonthAttrTotal.class);
    }
}

