package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.SysNotifyRepository;
import com.jz.jooq.media.tables.pojos.SysNotify;

@Lazy
@Service
public class SysNotifyService {

	@Autowired
	private SysNotifyRepository sysNotifyRepository;

	public int countUnreadNotifies(BrandEnum brand, String uid, long timestamp) {
		return sysNotifyRepository.countUnreadNotifies(brand, uid, timestamp);
	}

	public int countNotifies(BrandEnum brand, String uid) {
		return sysNotifyRepository.countNotifies(brand, uid);
	}

	public List<SysNotify> findNotifies(BrandEnum brand, String uid, int start, int size) {
		return sysNotifyRepository.findNotifies(brand, uid, start, size);
	}
}
