package com.jz.jar.media.enums;

/**
 * @Title DbField
 * @Package com.jz.jar.media.enums
 * @author tangjunfeng
 * @date 2018年8月15日 下午2:51:40
 * @version V1.0
 */
public enum DbField {

	special("任务-专项练习", null),
	everday("任务-每日任务", null),
	
	wait("专辑-待上线", null),
	online("专辑-上线", null),
	offline("专辑-下线", null),
	delete("专辑-删除", null),
	
	all("系统通知-所有用户", null),
	
	notice("C端消息更新-未读消息数量", "noticeCnt"), 
	newWorks("C端消息更新-关注的人最新作品数量", "followWorksCnt"), 
	sysNotify("C端消息更新-未读系统消息数量", "sysNotifyCnt"),
	
	video("消息/评论-视频", null), 
	works("消息/评论-作品", null), 
	url("消息/banner-链接地址", null), 
	playlist_video("banner-视频专辑", null),
	playlist_imgTxt("banner-图文专辑", null),
	theme("banner-专题", null),
	imgTxt("评论-图文", null),
	;

	private String fieldName;

	DbField(String remarks, String fieldName) {
		this.fieldName = fieldName;
	}

	public String getFieldName() {
		return fieldName;
	}
	
	public static DbField[] getCnts() {
		return new DbField[] { notice, newWorks, sysNotify };
	}
}
