/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.repository.BaseConditionRepository;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.PlaylistVideo;
import com.jz.jooq.media.tables.records.PlaylistVideoRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class PlaylistVideoRepository
extends MediaBaseRepository
implements BaseConditionRepository<PlaylistVideoRecord> {
    private static final PlaylistVideo PV = Tables.PLAYLIST_VIDEO;

    public List<String> findWids(String pid) {
        return this.mediaCtx.select((SelectField)PlaylistVideoRepository.PV.WID).from((TableLike)PV).where(new Condition[]{PlaylistVideoRepository.PV.PID.eq((Object)pid)}).orderBy((Field)PlaylistVideoRepository.PV.SEQ).fetchInto(String.class);
    }

    public List<String> findWids(String pid, int start, int size) {
        return this.mediaCtx.select((SelectField)PlaylistVideoRepository.PV.WID).from((TableLike)PV).where(new Condition[]{PlaylistVideoRepository.PV.PID.eq((Object)pid)}).orderBy((Field)PlaylistVideoRepository.PV.SEQ).limit(start, size).fetchInto(String.class);
    }

    public int countWids(String pid) {
        return this.mediaCtx.fetchCount((Table)PV, PlaylistVideoRepository.PV.PID.eq((Object)pid));
    }

    public List<com.jz.jooq.media.tables.pojos.PlaylistVideo> getVideos(Map<String, Collection<Integer>> pid2Times) {
        return this.mediaCtx.selectFrom((Table)PV).where(new Condition[]{this.getOrWhereCondition(PlaylistVideoRepository.PV.PID, PlaylistVideoRepository.PV.SEQ, pid2Times)}).fetchInto(com.jz.jooq.media.tables.pojos.PlaylistVideo.class);
    }

    public boolean isExistVideoForPlaylist(String pid, String wid) {
        return this.mediaCtx.fetchExists((Table)PV, PlaylistVideoRepository.PV.PID.eq((Object)pid).and(PlaylistVideoRepository.PV.WID.eq((Object)wid)));
    }

    public String getPlaylistForWid(String wid) {
        return (String)this.mediaCtx.select((SelectField)PlaylistVideoRepository.PV.PID).from((TableLike)PV).where(new Condition[]{PlaylistVideoRepository.PV.WID.eq((Object)wid)}).fetchAnyInto(String.class);
    }

    public Map<String, List<String>> getPlaylistForWid(Collection<String> wids) {
        return this.mediaCtx.select((SelectField)PlaylistVideoRepository.PV.WID, (SelectField)PlaylistVideoRepository.PV.PID).from((TableLike)PV).where(new Condition[]{PlaylistVideoRepository.PV.WID.in(wids)}).fetchGroups((Field)PlaylistVideoRepository.PV.WID, (Field)PlaylistVideoRepository.PV.PID);
    }
}

