package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.AuditStatus;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoImageText;

@Lazy
@Repository
public class TomatoImageTextRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoImageText IT = Tables.TOMATO_IMAGE_TEXT;
	private static final com.jz.jooq.media.tables.TomatoPlaylistImageText PI = Tables.TOMATO_PLAYLIST_IMAGE_TEXT;

	public List<TomatoImageText> findOnlineImageText(Collection<String> iids) {
		return mediaCtx.select(IT.ID, IT.NAME, IT.PIC, IT.WATCH_CNT, IT.LAST_UPDATED).from(IT)
				.where(IT.ID.in(iids).and(IT.STATUS.eq(AuditStatus.online.getCode()))).fetchInto(TomatoImageText.class);
	}

	public TomatoImageText getOnlineImageText(String iid) {
		return mediaCtx.selectFrom(IT).where(IT.ID.eq(iid).and(IT.STATUS.eq(AuditStatus.online.getCode())))
				.fetchAnyInto(TomatoImageText.class);
	}

	public List<String> findImageTextIdForPlaylist(String pid) {
		return mediaCtx.select(PI.IID).from(PI).where(PI.PID.eq(pid)).orderBy(PI.SEQ.asc()).fetchInto(String.class);
	}

	public int countImageTextIdForPlaylist(String pid) {
		return mediaCtx.fetchCount(PI, PI.PID.eq(pid));
	}

	public List<String> findImageTextIdForPlaylist(String pid, int start, int size) {
		return mediaCtx.select(PI.IID).from(PI).where(PI.PID.eq(pid)).orderBy(PI.SEQ.asc()).limit(start, size)
				.fetchInto(String.class);
	}

	public boolean isExistImageTextForPlaylist(String pid, String iid) {
		return mediaCtx.fetchExists(PI, PI.PID.eq(pid).and(PI.IID.eq(iid)));
	}

	public String getPlaylistForImageText(String iid) {
		return mediaCtx.select(PI.PID).from(PI).where(PI.IID.eq(iid)).fetchAnyInto(String.class);
	}

	public boolean isExistImageText(String iid) {
		return mediaCtx.fetchExists(IT, IT.ID.eq(iid));
	}

	public boolean isOnlineImageText(String iid) {
		return mediaCtx.fetchExists(IT, IT.ID.eq(iid).and(IT.STATUS.eq(AuditStatus.online.getCode())));
	}
	
	public Map<String, List<String>> getPlaylistForImageText(Collection<String> iids) {
		return mediaCtx.select(PI.IID, PI.PID).from(PI).where(PI.IID.in(iids)).fetchGroups(PI.IID, PI.PID);
	}
}
