package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoAttributes;

@Lazy
@Repository
public class TomatoAttributesRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoAttributes A = Tables.TOMATO_ATTRIBUTES;

	public TomatoAttributes getAttribute(String attrId) {
		return mediaCtx.selectFrom(A).where(A.ID.eq(attrId)).fetchAnyInto(TomatoAttributes.class);
	}

	public List<TomatoAttributes> findAttributes(Collection<String> attrIds) {
		return mediaCtx.selectFrom(A).where(A.ID.in(attrIds)).orderBy(A.SEQ.desc()).fetchInto(TomatoAttributes.class);
	}

	public List<TomatoAttributes> findHomeShowAttributes() {
		return mediaCtx.selectFrom(A).where(A.HOME_SHOW.eq(1)).orderBy(A.SEQ.desc()).fetchInto(TomatoAttributes.class);
	}

	public List<TomatoAttributes> findAllAttributes() {
		return mediaCtx.selectFrom(A).orderBy(A.SEQ.desc()).fetchInto(TomatoAttributes.class);
	}
}
