package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TestsAttributes;

@Lazy
@Repository
public class TestsAttributesRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TestsAttributes TA = Tables.TESTS_ATTRIBUTES;

	public List<TestsAttributes> getAttributesForDirections(Collection<String> directions) {
		return mediaCtx.selectFrom(TA).where(TA.DIRECTION.in(directions)).fetchInto(TestsAttributes.class);
	}
}
