/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.UserCollectImageText;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserCollectImageTextRepository
extends MediaBaseRepository {
    private static final UserCollectImageText IT = Tables.USER_COLLECT_IMAGE_TEXT;

    public void addCollect(String uid, String iid, String pid) {
        this.mediaCtx.insertInto((Table)IT, (Field)UserCollectImageTextRepository.IT.UID, (Field)UserCollectImageTextRepository.IT.IID, (Field)UserCollectImageTextRepository.IT.PID, (Field)UserCollectImageTextRepository.IT.CREATE_TIME).values((Object)uid, (Object)iid, (Object)pid, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public boolean isCollect(String uid, String iid) {
        return this.mediaCtx.fetchExists((Table)IT, UserCollectImageTextRepository.IT.UID.eq((Object)uid).and(UserCollectImageTextRepository.IT.IID.eq((Object)iid)));
    }

    public void deleteCollect(String uid, String iid) {
        this.mediaCtx.deleteFrom((Table)IT).where(new Condition[]{UserCollectImageTextRepository.IT.UID.eq((Object)uid).and(UserCollectImageTextRepository.IT.IID.eq((Object)iid))}).execute();
    }

    public int countCollect(String iid) {
        return this.mediaCtx.fetchCount((Table)IT, UserCollectImageTextRepository.IT.IID.eq((Object)iid));
    }

    public Map<String, Integer> countCollect(Collection<String> iids) {
        List maps = this.mediaCtx.select((SelectField)UserCollectImageTextRepository.IT.IID, (SelectField)DSL.count((Field)UserCollectImageTextRepository.IT.IID).as("ct")).from((TableLike)IT).where(new Condition[]{UserCollectImageTextRepository.IT.IID.in(iids)}).groupBy(new GroupField[]{UserCollectImageTextRepository.IT.IID}).fetchMaps();
        if (ArrayMapTools.isEmpty((Collection)maps)) {
            return Maps.newHashMap();
        }
        HashMap iid2Cnt = Maps.newHashMap();
        maps.forEach(it -> {
            if (ArrayMapTools.isEmpty((Map)it) || !ArrayMapTools.containsKeys((Map)it, (String[])new String[]{"iid", "ct"})) {
                return;
            }
            iid2Cnt.put(MapUtils.getString((Map)it, (Object)"iid"), MapUtils.getInteger((Map)it, (Object)"ct"));
        });
        return iid2Cnt;
    }

    public int countCollectForUser(String uid) {
        return this.mediaCtx.fetchCount((Table)IT, UserCollectImageTextRepository.IT.UID.eq((Object)uid));
    }

    public List<com.jz.jooq.media.tables.pojos.UserCollectImageText> getCollectForUser(String uid, int start, int size) {
        return this.mediaCtx.selectFrom((Table)IT).where(new Condition[]{UserCollectImageTextRepository.IT.UID.eq((Object)uid)}).orderBy(UserCollectImageTextRepository.IT.CREATE_TIME.desc()).limit(start, size).fetchInto(com.jz.jooq.media.tables.pojos.UserCollectImageText.class);
    }

    public List<String> filterCollectForUser(String uid, Collection<String> iids) {
        return this.mediaCtx.select((SelectField)UserCollectImageTextRepository.IT.IID).from((TableLike)IT).where(new Condition[]{UserCollectImageTextRepository.IT.UID.eq((Object)uid).and(UserCollectImageTextRepository.IT.IID.in(iids))}).fetchInto(String.class);
    }
}

