/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.AuditStatus;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.TomatoPlaylistImageText;
import com.jz.jooq.media.tables.pojos.TomatoImageText;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class TomatoImageTextRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.TomatoImageText IT = Tables.TOMATO_IMAGE_TEXT;
    private static final TomatoPlaylistImageText PI = Tables.TOMATO_PLAYLIST_IMAGE_TEXT;

    public List<TomatoImageText> findOnlineImageText(Collection<String> iids) {
        return this.mediaCtx.select((SelectField)TomatoImageTextRepository.IT.ID, (SelectField)TomatoImageTextRepository.IT.NAME, (SelectField)TomatoImageTextRepository.IT.PIC, (SelectField)TomatoImageTextRepository.IT.WATCH_CNT, (SelectField)TomatoImageTextRepository.IT.LAST_UPDATED).from((TableLike)IT).where(new Condition[]{TomatoImageTextRepository.IT.ID.in(iids).and(TomatoImageTextRepository.IT.STATUS.eq((Object)AuditStatus.online.getCode()))}).fetchInto(TomatoImageText.class);
    }

    public TomatoImageText getOnlineImageText(String iid) {
        return (TomatoImageText)this.mediaCtx.selectFrom((Table)IT).where(new Condition[]{TomatoImageTextRepository.IT.ID.eq((Object)iid).and(TomatoImageTextRepository.IT.STATUS.eq((Object)AuditStatus.online.getCode()))}).fetchAnyInto(TomatoImageText.class);
    }

    public List<String> findImageTextIdForPlaylist(String pid) {
        return this.mediaCtx.select((SelectField)TomatoImageTextRepository.PI.IID).from((TableLike)PI).where(new Condition[]{TomatoImageTextRepository.PI.PID.eq((Object)pid)}).orderBy(TomatoImageTextRepository.PI.SEQ.asc()).fetchInto(String.class);
    }

    public int countImageTextIdForPlaylist(String pid) {
        return this.mediaCtx.fetchCount((Table)PI, TomatoImageTextRepository.PI.PID.eq((Object)pid));
    }

    public List<String> findImageTextIdForPlaylist(String pid, int start, int size) {
        return this.mediaCtx.select((SelectField)TomatoImageTextRepository.PI.IID).from((TableLike)PI).where(new Condition[]{TomatoImageTextRepository.PI.PID.eq((Object)pid)}).orderBy(TomatoImageTextRepository.PI.SEQ.asc()).limit(start, size).fetchInto(String.class);
    }

    public boolean isExistImageTextForPlaylist(String pid, String iid) {
        return this.mediaCtx.fetchExists((Table)PI, TomatoImageTextRepository.PI.PID.eq((Object)pid).and(TomatoImageTextRepository.PI.IID.eq((Object)iid)));
    }
}

