package com.jz.jar.media.service;

import java.util.Collection;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.UserCollectImageTextRepository;

@Lazy
@Service
public class UserCollectImageTextService {

	@Autowired
	private UserCollectImageTextRepository userCollectImageTextRepository;

	public void addCollect(String uid, String iid, String pid) {
		userCollectImageTextRepository.addCollect(uid, iid, pid);
	}

	public boolean isCollect(String uid, String iid) {
		return userCollectImageTextRepository.isCollect(uid, iid);
	}

	public void deleteCollect(String uid, String iid) {
		userCollectImageTextRepository.deleteCollect(uid, iid);
	}

	public int countCollect(String iid) {
		return userCollectImageTextRepository.countCollect(iid);
	}

	public Map<String, Integer> countCollect(Collection<String> iids) {
		return userCollectImageTextRepository.countCollect(iids);
	}
}
