package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class UserCollectImageTextRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserCollectImageText IT = Tables.USER_COLLECT_IMAGE_TEXT;

	public void addCollect(String uid, String iid, String pid) {
		mediaCtx.insertInto(IT, IT.UID, IT.IID, IT.PID, IT.CREATE_TIME)
				.values(uid, iid, pid, System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}

	public boolean isCollect(String uid, String iid) {
		return mediaCtx.fetchExists(IT, IT.UID.eq(uid).and(IT.IID.eq(iid)));
	}

	public void deleteCollect(String uid, String iid) {
		mediaCtx.deleteFrom(IT).where(IT.UID.eq(uid).and(IT.IID.eq(iid))).execute();
	}

	public int countCollect(String iid) {
		return mediaCtx.fetchCount(IT, IT.IID.eq(iid));
	}

	public Map<String, Integer> countCollect(Collection<String> iids) {
		List<Map<String, Object>> maps = mediaCtx.select(IT.IID, DSL.count(IT.IID).as("ct")).from(IT)
				.where(IT.IID.in(iids)).groupBy(IT.IID).fetchMaps();
		if (ArrayMapTools.isEmpty(maps))
			return Maps.newHashMap();
		Map<String, Integer> iid2Cnt = Maps.newHashMap();
		maps.forEach(it -> {
			if (ArrayMapTools.isEmpty(it) || !ArrayMapTools.containsKeys(it, "iid", "ct"))
				return;
			iid2Cnt.put(MapUtils.getString(it, "iid"), MapUtils.getInteger(it, "ct"));
		});
		return iid2Cnt;
	}
}
