package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoPlaylistAttributes;

@Lazy
@Repository
public class TomatoPlaylistAttributesRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoPlaylistAttributes PA = Tables.TOMATO_PLAYLIST_ATTRIBUTES;
	private static final com.jz.jooq.media.tables.Playlist P = Tables.PLAYLIST;

	public List<String> filterPlaylistForAid(Collection<String> pids, String aid) {
		return mediaCtx.select(PA.PID).from(PA).where(PA.PID.in(pids).and(PA.ATTR_ID.eq(aid))).fetchInto(String.class);
	}

	public List<String> filterPlaylistForAid(Collection<String> pids, String aid, int start, int size) {
		return mediaCtx.select(PA.PID).from(PA).where(PA.PID.in(pids).and(PA.ATTR_ID.eq(aid)))
				.orderBy(PA.PID.sortAsc(pids)).limit(start, size).fetchInto(String.class);
	}

	public int countFilterPlaylistForAid(Collection<String> pids, String aid) {
		return mediaCtx.select(DSL.countDistinct(PA.PID)).from(PA).where(PA.PID.in(pids).and(PA.ATTR_ID.eq(aid)))
				.fetchAnyInto(Integer.class);
	}

	public List<TomatoPlaylistAttributes> filterPlaylistForAid(Collection<String> pids, Collection<String> aids) {
		return mediaCtx.selectFrom(PA).where(PA.PID.in(pids).and(PA.ATTR_ID.in(aids)))
				.fetchInto(TomatoPlaylistAttributes.class);
	}

	public List<String> findAttributeIds(Collection<String> pids) {
		return mediaCtx.selectDistinct(PA.ATTR_ID).from(PA).where(PA.PID.in(pids)).fetchInto(String.class);
	}

	public List<String> findPlaylistForAttrId(BrandEnum brand, String aid) {
		return mediaCtx.select(PA.PID).from(PA.join(P).on(PA.PID.eq(P.PID)))
				.where(PA.ATTR_ID.eq(aid).and(P.BRAND.eq(brand.name())).and(P.STATUS.eq(DbField.online.name())))
				.orderBy(P.CREATE_TIME.desc()).fetchInto(String.class);
	}
}
