/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.repository.PlaylistPicsRepository;
import com.jz.jooq.media.tables.pojos.PlaylistPics;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PlaylistPicsService {
    @Autowired
    private PlaylistPicsRepository playlistPicsRepository;

    public List<PlaylistPics> getPics(String pid) {
        return this.playlistPicsRepository.getPics(pid);
    }

    public List<PlaylistPics> getPics(Collection<String> pids) {
        return this.playlistPicsRepository.getPics(pids);
    }

    public Map<String, List<PlaylistPics>> getPicsHas(Collection<String> pids) {
        List<PlaylistPics> pics = this.getPics(pids);
        if (ArrayMapTools.isEmpty(pics)) {
            return Maps.newHashMap();
        }
        HashMap has = Maps.newHashMap();
        pics.forEach(it -> {
            if (!has.containsKey(it.getPid())) {
                has.put(it.getPid(), Lists.newArrayList());
            }
            ((List)has.get(it.getPid())).add(it);
        });
        return has;
    }
}

