package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TomatoPlaylistThemeRepository;
import com.jz.jooq.media.tables.pojos.TomatoPlaylistTheme;

@Lazy
@Service
public class TomatoPlaylistThemeService {

	@Autowired
	private TomatoPlaylistThemeRepository tomatoPlaylistThemeRepository;

	public List<TomatoPlaylistTheme> findPlaylistForTheme(Collection<String> themeIds) {
		return tomatoPlaylistThemeRepository.findPlaylistForTheme(themeIds);
	}

	public List<String> findPlaylistForTheme(String themeId) {
		return tomatoPlaylistThemeRepository.findPlaylistForTheme(themeId);
	}
}
