package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class TomatoPlaylistAttributesRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoPlaylistAttributes PA = Tables.TOMATO_PLAYLIST_ATTRIBUTES;

	public List<String> filterPlaylistForAid(Collection<String> pids, String aid) {
		return mediaCtx.select(PA.PID).from(PA).where(PA.PID.in(pids).and(PA.ATTR_ID.eq(aid))).fetchInto(String.class);
	}

	public int countFilterPlaylistForAid(Collection<String> pids, Collection<String> aids) {
		return mediaCtx.select(DSL.countDistinct(PA.PID)).from(PA).where(PA.PID.in(pids).and(PA.ATTR_ID.in(aids)))
				.fetchAnyInto(Integer.class);
	}

	public List<String> filterPlaylistForAid(Collection<String> pids, Collection<String> aids, int start, int size) {
		return mediaCtx.selectDistinct(PA.PID).from(PA).where(PA.PID.in(pids).and(PA.ATTR_ID.in(aids)))
				.orderBy(PA.PID.sortAsc(pids)).limit(start, size).fetchInto(String.class);
	}

	public List<String> findAttributeIds(Collection<String> pids) {
		return mediaCtx.select(PA.ATTR_ID).from(PA).where(PA.PID.in(pids)).fetchInto(String.class);
	}
}
