package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TomatoPlaylistAttributesRepository;

@Lazy
@Service
public class TomatoPlaylistAttributesService {

	@Autowired
	private TomatoPlaylistAttributesRepository tomatoPlaylistAttributesRepository;

	public List<String> filterPlaylistForAid(Collection<String> pids, String aid) {
		return tomatoPlaylistAttributesRepository.filterPlaylistForAid(pids, aid);
	}

	public int countFilterPlaylistForAid(Collection<String> pids, Collection<String> aids) {
		return tomatoPlaylistAttributesRepository.countFilterPlaylistForAid(pids, aids);
	}

	public List<String> filterPlaylistForAid(Collection<String> pids, Collection<String> aids, int start, int size) {
		return tomatoPlaylistAttributesRepository.filterPlaylistForAid(pids, aids, start, size);
	}

	public List<String> findAttributeIds(Collection<String> pids) {
		return tomatoPlaylistAttributesRepository.findAttributeIds(pids);
	}
}
