package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TaskPlayHistory;

@Lazy
@Repository
public class TaskPlayHistoryRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TaskPlayHistory TPH = Tables.TASK_PLAY_HISTORY;

	public void save(String tk, String suid, String pid, String wid) {
		mediaCtx.insertInto(TPH, TPH.TK, TPH.SUID, TPH.PID, TPH.WID, TPH.CREATE_TIME)
				.values(tk, suid, pid, wid, System.currentTimeMillis()).execute();
	}

	public boolean isExist(String tk, String suid, String pid, String wid) {
		return mediaCtx.fetchExists(TPH, TPH.TK.eq(tk).and(TPH.SUID.eq(suid)).and(TPH.PID.eq(pid)).and(TPH.WID.eq(wid)));
	}

	public List<TaskPlayHistory> findPlayHistories(String tk, String suid, Collection<String> pidArray) {
		return mediaCtx.selectFrom(TPH).where(TPH.TK.eq(tk).and(TPH.SUID.eq(suid)).and(TPH.PID.in(pidArray)))
				.fetchInto(TaskPlayHistory.class);
	}
}
