package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class StudentDayPlayRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.StudentDayPlay SDP = Tables.STUDENT_DAY_PLAY;

	public void saveTodayPlay(String today, String suid, String pid, int targetCnt, int playCnt, String nextWid) {
		mediaCtx.insertInto(SDP, SDP.DAY, SDP.SUID, SDP.PID, SDP.TARGET_CNT, SDP.PLAY_CNT, SDP.NEXT_WID)
				.values(today, suid, pid, targetCnt, playCnt, nextWid).onDuplicateKeyUpdate()
				.set(SDP.PLAY_CNT, SDP.PLAY_CNT.add(playCnt)).set(SDP.NEXT_WID, nextWid).execute();
	}

	public List<String> getTodayCompletePlaylist(String today, String suid, Collection<String> pids) {
		return mediaCtx.select(SDP.PID).from(SDP).where(
				SDP.DAY.eq(today).and(SDP.SUID.eq(suid)).and(SDP.PID.in(pids)).and(SDP.PLAY_CNT.ge(SDP.TARGET_CNT)))
				.fetchInto(String.class);
	}
	
	public int countLaterDays(String firstDay, String suid) {
		return mediaCtx.select(DSL.countDistinct(SDP.DAY)).from(SDP).where(SDP.DAY.ge(firstDay).and(SDP.SUID.eq(suid))).fetchAnyInto(Integer.class);
	}
	
	public Map<String, Integer> getEverdayCompletedPlaylistCount(Collection<String> days, String suid) {
		Result<Record2<String, Integer>> result = mediaCtx.select(SDP.DAY, DSL.count(SDP.DAY)).from(SDP)
				.where(SDP.DAY.in(days).and(SDP.SUID.eq(suid)).and(SDP.PLAY_CNT.ge(SDP.TARGET_CNT))).groupBy(SDP.DAY)
				.fetch();
		if (null == result || result.isEmpty())
			return Maps.newHashMap();
		Map<String, Integer> has = Maps.newHashMap();
		result.forEach(it -> has.put(it.value1(), it.value2()));
		return has;
	}
}
