package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class UserReadRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserRead UR = Tables.USER_READ;

	public void refreshReadTime(String uid) {
		long timeMillis = System.currentTimeMillis();
		mediaCtx.insertInto(UR, UR.UID, UR.READ_TIME).values(uid, timeMillis)
				.onDuplicateKeyUpdate().set(UR.READ_TIME, timeMillis).execute();
	}

	public long getReadTime(String uid) {
		List<Long> times = mediaCtx.select(UR.READ_TIME).from(UR).where(UR.UID.eq(uid)).fetchInto(Long.class);
		return ArrayMapTools.isNotEmpty(times) ? times.get(0) : 0l;
	}

}
