package com.jz.gymchina.jar.resources.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.gymchina.jar.resources.repository.UserGroupRepository;

@Lazy
@Service
public class UserGroupService {

	@Autowired
	private UserGroupRepository userGroupRepository;

	public List<String> getGroupsForUser(String uid) {
		return userGroupRepository.getGroupsForUser(uid);
	}

	public void clearGroups(String uid) {
		userGroupRepository.clearGroups(uid);
	}

	public void refreshGroups(String uid, List<String> gids) {
		userGroupRepository.refreshGroups(uid, gids);
	}
}
