package com.jz.gymchina.jar.resources.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.gymchina.jar.resources.repository.GymUserInfoRepository;
import com.jz.jooq.gymchina.resources.tables.pojos.GymUserInfo;

@Lazy
@Service
public class GymUserInfoService {

	@Autowired
	private GymUserInfoRepository gymUserInfoRepository;

	public boolean existUsername(String username) {
		return gymUserInfoRepository.existUsername(username);
	}

	public GymUserInfo getUserForLogin(String username, String password) {
		return gymUserInfoRepository.getUserForLogin(username, password);
	}

	public void addUserInfo(String uid, String username, String password, String nickname, String email) {
		gymUserInfoRepository.addUserInfo(uid, username, password, nickname, email);
	}

	public void updatePassword(String uid, String password) {
		gymUserInfoRepository.updatePassword(uid, password);
	}

	public void updateUserEnableInfo(String uid, int enable) {
		gymUserInfoRepository.updateUserEnableInfo(uid, enable);
	}

	public boolean isAdmin(String uid) {
		return gymUserInfoRepository.isAdmin(uid);
	}

	public int countUsers(String name, Integer enable) {
		return gymUserInfoRepository.countUsers(name, enable);
	}

	public List<GymUserInfo> getUsers(String name, Integer enable, int start, int size) {
		return gymUserInfoRepository.getUsers(name, enable, start, size);
	}

	public List<String> getForbiddenUsers() {
		return gymUserInfoRepository.getForbiddenUsers();
	}
}
