package com.jz.gymchina.jar.resources.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.gymchina.jar.resources.repository.GroupDirectoryRepository;
import com.jz.jooq.gymchina.resources.tables.pojos.GroupDir;

@Lazy
@Service
public class GroupDirectoryService {

	@Autowired
	private GroupDirectoryRepository groupDirectoryRepository;

	public List<GroupDir> getGroupDirectories() {
		return groupDirectoryRepository.getGroupDirectories();
	}

	public void clearDirectoriesInfo(String gid) {
		groupDirectoryRepository.clearDirectoriesInfo(gid);
	}

	public void refreshGroupDirectories(String gid, List<String> dirs) {
		groupDirectoryRepository.refreshGroupDirectories(gid, dirs);
	}

	public List<String> getDirectories(String gid) {
		return groupDirectoryRepository.getDirectories(gid);
	}
}
