package com.jz.gymchina.jar.resources.repository;

import java.util.List;

import org.jooq.InsertValuesStep2;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.records.UserGroupRecord;

@Lazy
@Repository
public class UserGroupRepository extends ResourceBaseRepository {

	private static com.jz.jooq.gymchina.resources.tables.UserGroup UG = Tables.USER_GROUP;

	public List<String> getGroupsForUser(String uid) {
		return resourcesCtx.select(UG.GID).from(UG).where(UG.UID.eq(uid)).fetchInto(String.class);
	}

	public void clearGroups(String uid) {
		resourcesCtx.deleteFrom(UG).where(UG.UID.eq(uid)).execute();
	}

	public void refreshGroups(String uid, List<String> gids) {
		String first = gids.remove(0);
		InsertValuesStep2<UserGroupRecord, String, String> values = resourcesCtx.insertInto(UG, UG.UID, UG.GID).values(uid, first);
		for (String gid : gids) {
			values = values.values(uid, gid);
		}
		values.onDuplicateKeyIgnore().execute();
	}
}
