package com.jz.gymchina.jar.resources.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.gymchina.jar.resources.repository.GroupInfoRepository;
import com.jz.jooq.gymchina.resources.tables.pojos.GroupInfo;

@Lazy
@Service
public class GroupInfoService {

	@Autowired
	private GroupInfoRepository groupInfoRepository;

	public void refreshGroupInfo(String gid, String name) {
		groupInfoRepository.refreshGroupInfo(gid, name);
	}

	public GroupInfo getGroupInfo(String gid) {
		return groupInfoRepository.getGroupInfo(gid);
	}

	public int countGroups(String name) {
		return groupInfoRepository.countGroups(name);
	}

	public List<GroupInfo> getGroups(String name, int start, int size) {
		return groupInfoRepository.getGroups(name, start, size);
	}

	public int countGroups(Collection<String> gids) {
		return groupInfoRepository.countGroups(gids);
	}
}
