package com.jz.gymchina.jar.resources.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.gymchina.jar.resources.repository.FileRepository;
import com.jz.jooq.gymchina.resources.tables.pojos.GymFile;

@Lazy
@Service
public class FileService {

	@Autowired
	private FileRepository fileRepository;

	public int countFilesForDirectory(String dirId) {
		return fileRepository.countFilesForDirectory(dirId);
	}

	public List<GymFile> getFilesForDirectory(String dirId) {
		return fileRepository.getFilesForDirectory(dirId);
	}

	public List<GymFile> getFilesForDirectory(Collection<String> dirIds) {
		return fileRepository.getFilesForDirectory(dirIds);
	}

	public List<GymFile> getFiles(Collection<String> fileIds) {
		return fileRepository.getFiles(fileIds);
	}

	public GymFile getFile(String fileId) {
		return fileRepository.getFile(fileId);
	}

	public boolean existFile(String fileId) {
		return fileRepository.existFile(fileId);
	}

	public int countExistFile(Collection<String> fileIds) {
		return fileRepository.countExistFile(fileIds);
	}

	public String getFileDirectory(String fileId) {
		return fileRepository.getFileDirectory(fileId);
	}

	public void updateFileName(String fileId, String name, String uid) {
		fileRepository.updateFileName(fileId, name, uid);
	}

	public void deleteFile(String fileId, String uid) {
		fileRepository.deleteFile(fileId, uid);
	}

	public void addFile(String fileId, String fileName, String dirId, String ext, String ossUrl, long size,
			String uid) {
		fileRepository.addFile(fileId, fileName, dirId, ext, ossUrl, size, uid);
	}

	public void batchInsertFiles(Collection<GymFile> files) {
		fileRepository.batchInsertFiles(files);
	}
}
