package com.jz.gymchina.jar.resources.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.text.StringTools;
import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.pojos.GroupInfo;

@Lazy
@Repository
public class GroupInfoRepository extends ResourceBaseRepository {

	private static com.jz.jooq.gymchina.resources.tables.GroupInfo GI = Tables.GROUP_INFO;

	public void refreshGroupInfo(String gid, String name) {
		resourcesCtx.insertInto(GI, GI.GID, GI.NAME).values(gid, name).onDuplicateKeyUpdate().set(GI.NAME, name)
				.execute();
	}

	public GroupInfo getGroupInfo(String gid) {
		return resourcesCtx.selectFrom(GI).where(GI.GID.eq(gid)).fetchAnyInto(GroupInfo.class);
	}

	private Condition getWhereCondition(String name) {
		Condition condition = DSL.trueCondition();
		if (StringTools.isNotEmptyAndBlank(name))
			condition = condition.and(GI.NAME.like("%" + name + "%"));
		return condition;
	}

	public int countGroups(String name) {
		return resourcesCtx.fetchCount(GI, getWhereCondition(name));
	}

	public List<GroupInfo> getGroups(String name, int start, int size) {
		return resourcesCtx.selectFrom(GI).where(getWhereCondition(name)).orderBy(GI.NAME.asc()).limit(start, size)
				.fetchInto(GroupInfo.class);
	}

	public int countGroups(Collection<String> gids) {
		return resourcesCtx.fetchCount(GI, GI.GID.in(gids));
	}
}
