package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.StudentSchoolRepository;

@Lazy
@Service
public class StudentSchoolService {

	@Autowired
	private StudentSchoolRepository studentSchoolRepository;

	public boolean isContainsSchool(String suid) {
		return studentSchoolRepository.isContainsSchool(suid);
	}

	public List<String> getContainsSchool(Collection<String> suidArray) {
		return studentSchoolRepository.getContainsSchool(suidArray);
	}
	
	public Long getFirstContractTime(String suid, String schoolId) {
		return studentSchoolRepository.getFirstContractTime(suid, schoolId);
	}
}
