/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CourseRepository;
import com.jz.jar.franchise.service.CourseFreeSettingService;
import com.jz.jar.franchise.wrapper.CourseLessonWrapper;
import com.jz.jar.franchise.wrapper.CourseWrapper;
import com.jz.jooq.franchise.tables.pojos.CourseHo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class CourseService {
    @Autowired
    private CourseRepository courseRepository;
    @Autowired
    private CourseFreeSettingService courseFreeSettingService;

    public Map<Integer, CourseWrapper> mutiGetCourseInfoMap(String brandId, String schoolId, Collection<Integer> courseIds, boolean withLessons) {
        HashMap map = Maps.newHashMap();
        ArrayList officalCourseIds = Lists.newArrayList();
        for (Integer courseId : courseIds) {
            if (courseId < 0) {
                CourseWrapper cw = this.courseFreeSettingService.getFreeCourseWrapper(brandId, courseId);
                if (cw == null) continue;
                map.put(courseId, cw);
                continue;
            }
            officalCourseIds.add(courseId);
        }
        List<CourseHo> hos = this.courseRepository.mutiGetHoCourse(brandId, officalCourseIds);
        if (ArrayMapTools.isNotEmpty(hos)) {
            hos.forEach(it -> map.put(it.getCourseId(), CourseWrapper.ofHo(it)));
            if (withLessons) {
                List<CourseLessonWrapper> lessons = this.courseRepository.mutiGetHoLessons(brandId, officalCourseIds);
                for (CourseLessonWrapper lesson : lessons) {
                    if (!map.containsKey(lesson.getCourseId())) continue;
                    ((CourseWrapper)map.get(lesson.getCourseId())).addLesson(lesson);
                }
            }
        }
        return map;
    }
}

