/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.cache.LessonCache;
import com.jz.jar.franchise.repository.FranchiseMultiTableJoinRepository;
import com.jz.jar.franchise.repository.LessonRepository;
import com.jz.jar.franchise.wrapper.LessonExtendWrapper;
import com.jz.jooq.franchise.tables.pojos.Lesson;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class LessonService {
    @Autowired
    private LessonRepository lessonRepository;
    @Autowired
    private FranchiseMultiTableJoinRepository franchiseMultiTableJoinRepository;
    @Autowired
    private LessonCache lessonCache;

    public List<Lesson> findLesson(Map<String, Collection<String>> school2Lessons) {
        HashMap tempKeys = Maps.newHashMap(school2Lessons);
        List<Lesson> cacheLesson = this.lessonCache.getLesson(school2Lessons);
        if (ArrayMapTools.isNotEmpty(cacheLesson)) {
            cacheLesson.forEach(it -> {
                ((Collection)tempKeys.get(it.getSchoolId())).remove(it.getLessonId());
                if (((Collection)tempKeys.get(it.getSchoolId())).isEmpty()) {
                    tempKeys.remove(it.getSchoolId());
                }
            });
        }
        if (ArrayMapTools.isEmpty((Map)tempKeys)) {
            return cacheLesson;
        }
        List<Lesson> dbLesson = this.lessonRepository.findLesson(tempKeys);
        if (ArrayMapTools.isEmpty(dbLesson)) {
            return cacheLesson;
        }
        this.lessonCache.setLesson(dbLesson);
        cacheLesson.addAll(dbLesson);
        return cacheLesson;
    }

    public Lesson getLesson(String schoolId, String lessonId) {
        Lesson lesson = this.lessonCache.getLesson(schoolId, lessonId);
        if (null != lesson) {
            return lesson;
        }
        lesson = this.lessonRepository.getLesson(schoolId, lessonId);
        if (null == lesson) {
            return null;
        }
        this.lessonCache.setLesson(lesson);
        return lesson;
    }

    public List<Lesson> findLessonForLimit(Map<String, Collection<String>> school2Lessons, int start, int size) {
        return this.lessonRepository.findLessonForLimit(school2Lessons, start, size);
    }

    public int countLesson(Map<String, Collection<String>> school2Lessons) {
        return this.lessonRepository.countLesson(school2Lessons);
    }

    public int countLessonForStudentStatus(Collection<String> schoolIds, String suid, Collection<Integer> statuses) {
        return this.franchiseMultiTableJoinRepository.countLessonForStudentStatus(schoolIds, suid, statuses);
    }

    public List<LessonExtendWrapper> findLessonForStudentStatus(Collection<String> schoolIds, String suid, Collection<Integer> statuses, boolean asc, int start, int size) {
        return this.franchiseMultiTableJoinRepository.findLessonForStudentStatus(schoolIds, suid, statuses, asc, start, size);
    }
}

