/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.LessonStudent;
import com.jz.jooq.franchise.tables.records.LessonStudentRecord;
import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class LessonStudentRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.LessonStudent LS = Tables.LESSON_STUDENT;
    private static List<TableField<LessonStudentRecord, ?>> simpleFields = Arrays.asList(LessonStudentRepository.LS.SCHOOL_ID, LessonStudentRepository.LS.LESSON_ID, LessonStudentRepository.LS.CONTRACT_ID, LessonStudentRepository.LS.TYPE, LessonStudentRepository.LS.STATUS);

    public List<LessonStudent> findSimpleLessonStudentInfo(String suid) {
        return this.franchiseCtx.select(simpleFields).from((TableLike)LS).where(new Condition[]{LessonStudentRepository.LS.SUID.eq((Object)suid)}).fetchInto(LessonStudent.class);
    }

    public LessonStudent getSimpleLessonStudent(String schoolId, String lessonId, String suid) {
        return (LessonStudent)this.franchiseCtx.select(simpleFields).from((TableLike)LS).where(new Condition[]{LessonStudentRepository.LS.SCHOOL_ID.eq((Object)schoolId).and(LessonStudentRepository.LS.LESSON_ID.eq((Object)lessonId)).and(LessonStudentRepository.LS.SUID.eq((Object)suid))}).fetchAnyInto(LessonStudent.class);
    }

    public void updateStatus(String schoolId, String lessonId, String suid, int status) {
        this.franchiseCtx.update((Table)LS).set((Field)LessonStudentRepository.LS.STATUS, (Object)status).where(new Condition[]{LessonStudentRepository.LS.SCHOOL_ID.eq((Object)schoolId).and(LessonStudentRepository.LS.LESSON_ID.eq((Object)lessonId)).and(LessonStudentRepository.LS.SUID.eq((Object)suid))}).execute();
    }

    public List<LessonStudent> findSimpleFinishedLessonInfo(String suid) {
        return this.franchiseCtx.select(simpleFields).from((TableLike)LS).where(new Condition[]{LessonStudentRepository.LS.SUID.eq((Object)suid).and(LessonStudentRepository.LS.TYPE.eq((Object)1)).and(LessonStudentRepository.LS.STATUS.in((Object[])new Integer[]{1, 2, 4}))}).fetchInto(LessonStudent.class);
    }
}

