/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.google.common.collect.Lists;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jar.franchise.wrapper.LessonExtendWrapper;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.Lesson;
import com.jz.jooq.franchise.tables.LessonStudent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class FranchiseMultiTableJoinRepository
extends FranchiseBaseRepository {
    private static final Lesson LE = Tables.LESSON;
    private static final LessonStudent LS = Tables.LESSON_STUDENT;

    private TableOnConditionStep getLessonJoinLessonStudent() {
        return LS.join((TableLike)LE).on(new Condition[]{FranchiseMultiTableJoinRepository.LS.SCHOOL_ID.eq((Field)FranchiseMultiTableJoinRepository.LE.SCHOOL_ID).and(FranchiseMultiTableJoinRepository.LS.LESSON_ID.eq((Field)FranchiseMultiTableJoinRepository.LE.LESSON_ID))});
    }

    private Condition getCondition(Collection<String> schoolIds, String suid, Collection<Integer> statuses) {
        return FranchiseMultiTableJoinRepository.LS.SCHOOL_ID.in(schoolIds).and(FranchiseMultiTableJoinRepository.LS.SUID.eq((Object)suid)).and(FranchiseMultiTableJoinRepository.LS.STATUS.in(statuses));
    }

    public int countLessonForStudentStatus(Collection<String> schoolIds, String suid, Collection<Integer> statuses) {
        return this.franchiseCtx.fetchCount((Table)this.getLessonJoinLessonStudent(), this.getCondition(schoolIds, suid, statuses));
    }

    public List<LessonExtendWrapper> findLessonForStudentStatus(Collection<String> schoolIds, String suid, Collection<Integer> statuses, boolean asc, int start, int size) {
        SortField sortField = asc ? FranchiseMultiTableJoinRepository.LE.START_TIME.asc() : FranchiseMultiTableJoinRepository.LE.START_TIME.desc();
        ArrayList resultFields = Lists.newArrayList((Object[])LE.fields());
        resultFields.add(FranchiseMultiTableJoinRepository.LS.CONTRACT_ID);
        return this.franchiseCtx.select((Collection)resultFields).from((TableLike)this.getLessonJoinLessonStudent()).where(new Condition[]{this.getCondition(schoolIds, suid, statuses)}).orderBy(sortField).limit(start, size).fetchInto(LessonExtendWrapper.class);
    }
}

