package com.jz.jar.franchise.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.SchoolRepository;
import com.jz.jooq.franchise.tables.pojos.School;

/**
 * @Title SchoolService
 * @Package com.jz.jar.franchise.service
 * @author tangjunfeng
 * @date 2018年8月28日 下午5:59:28
 * @version V1.0
 */
@Lazy
@Service
public class SchoolService {

	@Autowired
	private SchoolRepository schoolRepository;

	public School getSchool(String id) {
		return schoolRepository.getSchool(id);
	}
	
	public List<School> getSchools(String brand, String prov) {
		return this.getSchools(brand, prov, null);
	}
	
	public List<School> getSchools(String brand, String prov, String city) {
		return schoolRepository.getSchools(brand, prov, city);
	}
	
	public String getSchoolName(String id) {
		return schoolRepository.getSchoolName(id);
	}
	
	public List<String> getSchoolIdForBrand(String brand) {
		return schoolRepository.getSchoolIdForBrand(brand);
	}
}
