package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.CourseHoLesson;
import com.jz.jooq.franchise.tables.records.CourseHoLessonRecord;

@Lazy
@Repository
public class CourseHoLessonRepository extends FranchiseBaseRepository implements FranchiseConditionRepository<CourseHoLessonRecord> {

	private static final com.jz.jooq.franchise.tables.CourseHoLesson CHL = Tables.COURSE_HO_LESSON;

	public List<CourseHoLesson> findHoLession(String brand, Map<Integer, Collection<Integer>> course2LessonTimes) {
		return franchiseCtx.selectFrom(CHL)
				.where(CHL.BRAND_ID.eq(brand).and(getOrWhereCondition(CHL.COURSE_ID, CHL.LESSON_TIME, course2LessonTimes)))
				.fetchInto(CourseHoLesson.class);
	}
}
