package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.jar.franchise.repository.LessonDakaRepository;
import com.jz.jar.franchise.repository.LessonStudentDakaRepository;
import com.jz.jooq.franchise.tables.pojos.LessonDaka;
import com.jz.jooq.franchise.tables.pojos.LessonStudentDaka;
import com.jz.jooq.franchise.tables.records.LessonStudentDakaRecord;

@Lazy
@Service
public class LessonDakaService {

	@Autowired
	private LessonDakaRepository lessonDakaRepository;
	@Autowired
	private LessonStudentDakaRepository lessonStudentDakaRepository;

	public LessonDaka getDakaByLessonId(String schoolId, String lessonId) {
		return lessonDakaRepository.getDakaByLessonId(schoolId, lessonId);
	}

	public Map<String, LessonDaka> mutiGetSchoolLessonId2Daka(Map<String, Collection<String>> schoolId2LessonIds) {
		List<LessonDaka> list = lessonDakaRepository.mutiGetDakaBySchoolIdsLessonIds(schoolId2LessonIds);
		Map<String, LessonDaka> lessonId2Daka = Maps.newHashMap();
		for (LessonDaka d : list) {
			lessonId2Daka.put(d.getLessonId(), d);
		}
		return lessonId2Daka;
	}

	public void createStudentDaka(LessonStudentDakaRecord record) {
		lessonStudentDakaRepository.createStudentDaka(record);
	}

	public void updateStudentDaka(LessonStudentDakaRecord record) {
		lessonStudentDakaRepository.updateStudentDaka(record);
	}

	public LessonStudentDaka getStudentDaka(String schoolId, String lessonId, String suid) {
		return lessonStudentDakaRepository.getStudentDaka(schoolId, lessonId, suid);
	}

	public List<LessonStudentDaka> getStudentDakaListByLessonId(String schoolId, String lessonId) {
		return lessonStudentDakaRepository.getStudentDakaListByLessonId(schoolId, lessonId);
	}

	public Map<String, LessonStudentDaka> mutiGetStudentLessonId2Daka(String suid,
			Map<String, Collection<String>> schoolId2LessonIds) {
		List<LessonStudentDaka> list = lessonStudentDakaRepository.mutiGetStudentDakaBySchoolIdsLessonIds(suid,
				schoolId2LessonIds);
		Map<String, LessonStudentDaka> lessonId2Daka = Maps.newHashMap();
		for (LessonStudentDaka d : list) {
			lessonId2Daka.put(d.getLessonId(), d);
		}
		return lessonId2Daka;
	}
}
