/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jar.franchise.repository.FranchiseConditionRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.Lesson;
import com.jz.jooq.franchise.tables.records.LessonRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class LessonRepository
extends FranchiseBaseRepository
implements FranchiseConditionRepository<LessonRecord> {
    private static final Lesson LE = Tables.LESSON;

    public List<com.jz.jooq.franchise.tables.pojos.Lesson> findLesson(Map<String, Collection<String>> school2Lessons) {
        Condition condition = this.getOrWhereCondition(LessonRepository.LE.SCHOOL_ID, LessonRepository.LE.LESSON_ID, school2Lessons);
        return this.franchiseCtx.selectFrom((Table)LE).where(new Condition[]{condition}).orderBy(LessonRepository.LE.START_TIME.asc()).fetchInto(com.jz.jooq.franchise.tables.pojos.Lesson.class);
    }

    public com.jz.jooq.franchise.tables.pojos.Lesson getLesson(String schoolId, String lessonId) {
        return (com.jz.jooq.franchise.tables.pojos.Lesson)this.franchiseCtx.selectFrom((Table)LE).where(new Condition[]{LessonRepository.LE.SCHOOL_ID.eq((Object)schoolId).and(LessonRepository.LE.LESSON_ID.eq((Object)lessonId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.Lesson.class);
    }

    private Condition getWhereCondition(Map<String, Collection<String>> school2Lessons, Long currentTimeMillis) {
        Condition condition = this.getOrWhereCondition(LessonRepository.LE.SCHOOL_ID, LessonRepository.LE.LESSON_ID, school2Lessons);
        if (currentTimeMillis > 0L) {
            condition = condition.and(LessonRepository.LE.END_TIME.ge((Object)currentTimeMillis));
        }
        return condition;
    }

    public List<com.jz.jooq.franchise.tables.pojos.Lesson> findLesson(Map<String, Collection<String>> school2Lessons, boolean asc, Long currentTimeMillis, int start, int size) {
        SortField sortField = asc ? LessonRepository.LE.START_TIME.asc() : LessonRepository.LE.START_TIME.desc();
        return this.franchiseCtx.selectFrom((Table)LE).where(new Condition[]{this.getWhereCondition(school2Lessons, currentTimeMillis)}).orderBy(sortField).limit(start, size).fetchInto(com.jz.jooq.franchise.tables.pojos.Lesson.class);
    }

    public int countLesson(Map<String, Collection<String>> school2Lessons, Long currentTimeMillis) {
        return this.franchiseCtx.fetchCount((Table)LE, this.getWhereCondition(school2Lessons, currentTimeMillis));
    }

    public List<com.jz.jooq.franchise.tables.pojos.Lesson> findLessonProByTime(Map<String, Collection<String>> school2Lessons, Long startTime, Long endTime) {
        Condition condition = this.getOrWhereCondition(LessonRepository.LE.SCHOOL_ID, LessonRepository.LE.LESSON_ID, school2Lessons);
        if (startTime != null && endTime != null) {
            condition = condition.and(LessonRepository.LE.START_TIME.between((Object)startTime, (Object)endTime));
        }
        return this.franchiseCtx.selectFrom((Table)LE).where(new Condition[]{condition}).fetchInto(com.jz.jooq.franchise.tables.pojos.Lesson.class);
    }

    public com.jz.jooq.franchise.tables.pojos.Lesson findOneTodayLesson(Map<String, Collection<String>> school2Lessons, long startTime, long endTime) {
        Condition condition = this.getOrWhereCondition(LessonRepository.LE.SCHOOL_ID, LessonRepository.LE.LESSON_ID, school2Lessons);
        condition = condition.and(LessonRepository.LE.END_TIME.between((Object)startTime, (Object)endTime));
        return (com.jz.jooq.franchise.tables.pojos.Lesson)this.franchiseCtx.selectFrom((Table)LE).where(new Condition[]{condition}).orderBy(LessonRepository.LE.START_TIME.asc()).limit(1).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.Lesson.class);
    }

    public Map<String, String> getLessonId2Teacher(Map<String, Collection<String>> school2Lessons) {
        Condition condition = this.getOrWhereCondition(LessonRepository.LE.SCHOOL_ID, LessonRepository.LE.LESSON_ID, school2Lessons);
        return this.franchiseCtx.select((SelectField)LessonRepository.LE.LESSON_ID, (SelectField)LessonRepository.LE.TEACHER).from((TableLike)LE).where(new Condition[]{condition}).fetchMap((Field)LessonRepository.LE.LESSON_ID, (Field)LessonRepository.LE.TEACHER);
    }
}

