package com.jz.jar.franchise.service;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CourseTomatoPlanRepository;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoPlan;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoSchoolPlan;
import com.jz.jooq.franchise.tables.pojos.Lesson;

@Lazy
@Service
public class CourseTomatoService {

	@Autowired
	private CourseTomatoPlanRepository courseTomatoPlanRepository;

	public Map<String, String> mutiCalSchoolSimplePlans(String brandId, List<Lesson> lessons) {
		if (ArrayMapTools.isEmpty(lessons)) {
			return null;
		}
		// 处理基本的信息
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		Map<Long, String> startTime2MondayMap = Maps.newHashMap(); // 为了后面效率
		Map<Integer, Set<String>> courseId2MondaysMap = Maps.newHashMap();
		List<Triple<String, Integer, String>> schoolIdCourseIdMondayList = Lists.newArrayList();

		Set<String> auditionIds = Sets.newHashSet();
		Set<String> schoolIds = Sets.newHashSet();
		for (Lesson l : lessons) {
			int courseId = l.getCourseId();
			if (courseId < 0) {
				auditionIds.add(l.getContent());
				schoolIds.add(l.getSchoolId());
			} else {
				long startTime = l.getStartTime();
				String monday = df.format(this.getMondayOfThisWeek(startTime));
				if (courseId2MondaysMap.containsKey(courseId)) {
					courseId2MondaysMap.get(courseId).add(monday);
				} else {
					courseId2MondaysMap.put(courseId, Sets.newHashSet(monday));
				}
				startTime2MondayMap.put(startTime, monday);
				schoolIdCourseIdMondayList.add(Triple.of(l.getSchoolId(), l.getCourseId(), monday));
			}
		}

		Map<String, String> courseIdMonday2NameMap = null; // 总部
		Map<String, String> schoolCourseIdMonday2NameMap = null; // 分校
		if (ArrayMapTools.isNotEmpty(schoolIdCourseIdMondayList)) {
			// 总部计划
			courseIdMonday2NameMap = Maps.newHashMap();
			List<CourseTomatoPlan> hoPlans = courseTomatoPlanRepository.getSimplePlansByCourseId2MondayMap(brandId,
					courseId2MondaysMap);
			for (CourseTomatoPlan p : hoPlans) {
				String key = p.getCourseId() + "$" + p.getMonday();
				courseIdMonday2NameMap.put(key, p.getName());
			}

			// 分校计划
			schoolCourseIdMonday2NameMap = Maps.newHashMap();
			List<CourseTomatoSchoolPlan> schoolPlans = courseTomatoPlanRepository
					.getSimplePlansByTriple(schoolIdCourseIdMondayList);
			if (ArrayMapTools.isNotEmpty(schoolPlans)) {
				List<String> planIds = schoolPlans.stream().map(c -> c.getPlanId()).collect(Collectors.toList());
				Map<String, String> schoolPlanMap = courseTomatoPlanRepository.mutiGetPlanMap(brandId, planIds);
				for (CourseTomatoSchoolPlan sp : schoolPlans) {
					if (schoolPlanMap.containsKey(sp.getPlanId())) {
						String key = sp.getSchoolId() + "$" + sp.getCourseId() + "$" + sp.getMonday();
						schoolCourseIdMonday2NameMap.put(key, schoolPlanMap.get(sp.getPlanId()));
					}
				}
			}
		}

		// 试听课逻辑
		Map<String, String> auditionMap = null;
		if (ArrayMapTools.isNotEmpty(auditionIds)) {
			auditionMap = courseTomatoPlanRepository.mutiGetAuditionMap(brandId, schoolIds, auditionIds);
		}

		// 做最后lessonId->planName的封装
		Map<String, String> rsMap = Maps.newHashMap();
		for (Lesson l : lessons) {
			int courseId = l.getCourseId();
			if (courseId < 0) {
				if (auditionMap.containsKey(l.getContent())) {
					rsMap.put(l.getLessonId(), auditionMap.get(l.getContent()));
				}
			} else {
				if (schoolCourseIdMonday2NameMap != null && schoolCourseIdMonday2NameMap != null) { // 走到这里，这里一定不会为空
					long startTime = l.getStartTime();
					String monday = startTime2MondayMap.get(startTime); // 这里不会为空，因为上面处理过
					String schoolKey = l.getSchoolId() + "$" + l.getCourseId() + "$" + monday;
					String hoKey = l.getCourseId() + "$" + monday;
					if (schoolCourseIdMonday2NameMap.containsKey(schoolKey)) {
						rsMap.put(l.getLessonId(), schoolCourseIdMonday2NameMap.get(schoolKey));
					} else if (courseIdMonday2NameMap.containsKey(hoKey)) {
						rsMap.put(l.getLessonId(), courseIdMonday2NameMap.get(hoKey));
					}
				}
			}
		}
		return rsMap;
	}

	public String calSchoolSimplePlan(String brandId, Lesson l) {
		if (l == null) {
			return null;
		}
		String schoolId = l.getSchoolId();
		int courseId = l.getCourseId();
		if (courseId < 0) {
			String auditionId = l.getContent();
			return courseTomatoPlanRepository.getAuditionName(brandId, schoolId, auditionId);
		}

		// 处理基本的信息
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		String monday = df.format(this.getMondayOfThisWeek(l.getStartTime()));

		CourseTomatoSchoolPlan schoolPlan = courseTomatoPlanRepository.getSchoolPlan(schoolId, courseId, monday);
		if (schoolPlan != null) {
			// 分校自定义计划
			return courseTomatoPlanRepository.getPlanName(brandId, schoolPlan.getPlanId());
		} else {
			// 总部计划
			return courseTomatoPlanRepository.getHoPlanName(brandId, courseId, monday);
		}
	}

	private Date getMondayOfThisWeek(long time) {
		Calendar c = Calendar.getInstance();
		c.setTimeInMillis(time);
		if (c.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY) {
			c.add(Calendar.DATE, -1);
		}
		c.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
		c.set(Calendar.HOUR_OF_DAY, 0);
		c.set(Calendar.MINUTE, 0);
		c.set(Calendar.SECOND, 0);
		c.set(Calendar.MILLISECOND, 0);
		return c.getTime();
	}

	public Map<Integer, String> getCourseTomatoNameForIds(String brandId, Collection<Integer> courseIds) {
		return courseTomatoPlanRepository.getCourseTomatoNameForIds(brandId, courseIds);
	}
	
	public String getCourseTomatoNameForId(String brandId, Integer courseId) {
		return courseTomatoPlanRepository.getCourseTomatoNameForId(brandId, courseId);
	}
}
