package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.CoursePackCreateSetting;
import com.jz.jooq.franchise.tables.pojos.CoursePackHo;
import com.jz.jooq.franchise.tables.pojos.CoursePackHoDetail;
import com.jz.jooq.franchise.tables.pojos.CoursePackHoPrice;
import com.jz.jooq.franchise.tables.pojos.CoursePackSchool;
import com.jz.jooq.franchise.tables.pojos.CoursePackSchoolDetail;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class CoursePackRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.CoursePackHo CPH = Tables.COURSE_PACK_HO;
	private static final com.jz.jooq.franchise.tables.CoursePackHoDetail CPHD = Tables.COURSE_PACK_HO_DETAIL;
	private static final com.jz.jooq.franchise.tables.CoursePackHoDisable CPHDIS = Tables.COURSE_PACK_HO_DISABLE;
	private static final com.jz.jooq.franchise.tables.CoursePackHoPrice CPHP = Tables.COURSE_PACK_HO_PRICE;

	private static final com.jz.jooq.franchise.tables.CoursePackSchool CPS = Tables.COURSE_PACK_SCHOOL;
	private static final com.jz.jooq.franchise.tables.CoursePackSchoolDetail CPSD = Tables.COURSE_PACK_SCHOOL_DETAIL;

	private static final com.jz.jooq.franchise.tables.CoursePackCreateSetting CPCS = Tables.COURSE_PACK_CREATE_SETTING;

	public List<CoursePackHo> getAllCoursePackHo(String brandId) {
		return franchiseCtx.selectFrom(CPH).where(CPH.BRAND_ID.eq(brandId)).fetchInto(CoursePackHo.class);
	}

	public List<CoursePackHoDetail> getHoDetails(String brandId, Collection<String> coursePackIds) {
		return franchiseCtx.selectFrom(CPHD).where(CPHD.COURSE_PACK_ID.in(coursePackIds))
				.fetchInto(CoursePackHoDetail.class);
	}

	public List<Integer> getHoCourseIds(String brandId, String coursePackId) {
		return franchiseCtx.select(CPHD.COURSE_ID).from(CPHD).where(CPHD.COURSE_PACK_ID.eq(coursePackId))
				.fetchInto(Integer.class);
	}

	public List<String> getHoDisable(String schoolId) {
		return franchiseCtx.select(CPHDIS.COURSE_PACK_ID).from(CPHDIS).where(CPHDIS.SCHOOL_ID.eq(schoolId))
				.fetchInto(String.class);
	}

	public List<CoursePackHoPrice> getHoPrices(Collection<String> coursePackIds, int cityLevel) {
		return franchiseCtx.selectFrom(CPHP)
				.where(CPHP.COURSE_PACK_ID.in(coursePackIds).and(CPHP.CITY_LEVEL.eq(cityLevel)))
				.fetchInto(CoursePackHoPrice.class);
	}

	public CoursePackHoPrice getHoPrice(String coursePackId, int cityLevel) {
		return franchiseCtx.selectFrom(CPHP)
				.where(CPHP.COURSE_PACK_ID.eq(coursePackId).and(CPHP.CITY_LEVEL.eq(cityLevel)))
				.fetchAnyInto(CoursePackHoPrice.class);
	}

	public List<CoursePackSchool> getPackSchool(String schoolId) {
		return franchiseCtx.selectFrom(CPS).where(CPS.SCHOOL_ID.eq(schoolId)).fetchInto(CoursePackSchool.class);
	}

	public List<CoursePackSchool> getEnablePackSchool(String schoolId) {
		return franchiseCtx.selectFrom(CPS).where(CPS.SCHOOL_ID.eq(schoolId).and(CPS.ENABLE.eq(1)))
				.fetchInto(CoursePackSchool.class);
	}

	public List<CoursePackSchoolDetail> getSchoolDetail(String schoolId) {
		return franchiseCtx.selectFrom(CPSD).where(CPSD.SCHOOL_ID.eq(schoolId)).fetchInto(CoursePackSchoolDetail.class);
	}

	public List<Integer> getSchoolCourseIds(String schoolId, String coursePackId) {
		return franchiseCtx.select(CPSD.COURSE_ID).from(CPSD)
				.where(CPSD.SCHOOL_ID.eq(schoolId).and(CPSD.COURSE_PACK_ID.eq(coursePackId))).fetchInto(Integer.class);
	}

	public List<CoursePackHo> mutiGetCoursePackHo(Collection<String> coursePackIds) {
		return franchiseCtx.selectFrom(CPH).where(CPH.COURSE_PACK_ID.in(coursePackIds)).fetchInto(CoursePackHo.class);
	}

	public List<CoursePackSchool> mutiGetPackSchool(String schoolId, Collection<String> coursePackIds) {
		return franchiseCtx.selectFrom(CPS).where(CPS.SCHOOL_ID.eq(schoolId).and(CPS.COURSE_PACK_ID.in(coursePackIds)))
				.fetchInto(CoursePackSchool.class);
	}

	public CoursePackHo getCoursePackHo(String coursePackId) {
		return franchiseCtx.selectFrom(CPH).where(CPH.COURSE_PACK_ID.eq(coursePackId)).fetchAnyInto(CoursePackHo.class);
	}

	public CoursePackSchool getCoursePackSchool(String schoolId, String coursePackId) {
		return franchiseCtx.selectFrom(CPS).where(CPS.SCHOOL_ID.eq(schoolId).and(CPS.COURSE_PACK_ID.eq(coursePackId)))
				.fetchAnyInto(CoursePackSchool.class);
	}

	public CoursePackCreateSetting getCreateSetting(String brandId, int cityLevel) {
		return franchiseCtx.selectFrom(CPCS).where(CPCS.BRAND_ID.eq(brandId).and(CPCS.CITY_LEVEL.eq(cityLevel)))
				.fetchAnyInto(CoursePackCreateSetting.class);
	}

	public List<String> getHoPackIdsByCourseId(String brandId, int courseId) {
		return franchiseCtx.select(CPHD.COURSE_PACK_ID).from(CPHD)
				.where(CPHD.BRAND_ID.eq(brandId).and(CPHD.COURSE_ID.eq(courseId))).fetchInto(String.class);
	}

	public List<String> getSchoolPackIdsByCourseId(String schoolId, int courseId) {
		return franchiseCtx.select(CPSD.COURSE_PACK_ID).from(CPSD)
				.where(CPSD.SCHOOL_ID.eq(schoolId).and(CPSD.COURSE_ID.eq(courseId))).fetchInto(String.class);
	}

}
