/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class INetTools {
    private static InetAddress inetAddress() {
        try {
            InetAddress ip = null;
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    ip = ips.nextElement();
                    if (ip.isLoopbackAddress() || !ip.isSiteLocalAddress()) continue;
                    return ip;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static String localNetAddress() {
        InetAddress inet = INetTools.inetAddress();
        return null != inet ? inet.getHostAddress() : "127.0.0.1";
    }

    public static String MACAddress() {
        InetAddress inet = INetTools.inetAddress();
        if (null != inet) {
            try {
                byte[] mac = NetworkInterface.getByInetAddress(inet).getHardwareAddress();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < mac.length; ++i) {
                    String s;
                    if (i != 0) {
                        sb.append("-");
                    }
                    sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                }
                return sb.toString().toUpperCase();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "00-00-00-00-00";
    }

    public static String localName() {
        InetAddress inet = INetTools.inetAddress();
        return null != inet ? inet.getHostName() : "";
    }
}

