/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.http;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.ConnectTools;
import com.jz.common.utils.text.StringTools;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

class ConnectSSLGet {
    ConnectSSLGet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String send(String url, Map<String, String> params, String charsetName) throws ClientProtocolException, IOException, GeneralSecurityException {
        String result = null;
        try (CloseableHttpClient closeableHttpClient = ConnectTools.createSSLInsecureClient();){
            StringBuffer strParams = new StringBuffer();
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            if (ArrayMapTools.isNotEmpty(params)) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    parameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
            }
            if (StringTools.isNotEmpty((CharSequence)strParams.toString())) {
                url = url + (url.indexOf("?") > 0 ? "&" : "?") + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(parameters, charsetName));
            }
            HttpGet sslGet = new HttpGet(url);
            sslGet.setHeader("accept", "*/*");
            sslGet.setHeader("connection", "keep-alive");
            sslGet.setHeader("user-agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:38.0) Gecko/20100101 Firefox/38.0");
            CloseableHttpResponse response = closeableHttpClient.execute((HttpUriRequest)sslGet);
            if (200 == response.getStatusLine().getStatusCode() && null != response.getEntity()) {
                String charset = ConnectTools.getCharsetFromResponse((HttpResponse)response);
                charsetName = StringTools.isNotEmpty((CharSequence)charset) ? charset : charsetName;
                result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName(charsetName));
            }
        }
        return result;
    }
}

