/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.collection;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;

abstract class AbstractMapTools
extends ArrayUtils {
    public static final Map EMPTY_MAP = new HashMap(1);
    public static final SortedMap EMPTY_SORTED_MAP = new TreeMap();

    AbstractMapTools() {
    }

    public static Object getObject(Map map, Object key) {
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public static String getString(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            return answer.toString();
        }
        return null;
    }

    public static Boolean getBoolean(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            if (answer instanceof Boolean) {
                return (Boolean)answer;
            }
            if (answer instanceof String) {
                return new Boolean((String)answer);
            }
            if (answer instanceof Number) {
                Number n = (Number)answer;
                return n.intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    public static Number getNumber(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            if (answer instanceof Number) {
                return (Number)answer;
            }
            if (answer instanceof String) {
                try {
                    String text = (String)answer;
                    return NumberFormat.getInstance().parse(text);
                }
                catch (ParseException e) {
                    AbstractMapTools.logInfo(e);
                }
            }
        }
        return null;
    }

    public static Byte getByte(Map map, Object key) {
        Number answer = AbstractMapTools.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Byte) {
            return (Byte)answer;
        }
        return new Byte(answer.byteValue());
    }

    public static Short getShort(Map map, Object key) {
        Number answer = AbstractMapTools.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Short) {
            return (Short)answer;
        }
        return new Short(answer.shortValue());
    }

    public static Integer getInteger(Map map, Object key) {
        Number answer = AbstractMapTools.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Integer) {
            return (Integer)answer;
        }
        return new Integer(answer.intValue());
    }

    public static Long getLong(Map map, Object key) {
        Number answer = AbstractMapTools.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Long) {
            return (Long)answer;
        }
        return new Long(answer.longValue());
    }

    public static Float getFloat(Map map, Object key) {
        Number answer = AbstractMapTools.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Float) {
            return (Float)answer;
        }
        return new Float(answer.floatValue());
    }

    public static Double getDouble(Map map, Object key) {
        Number answer = AbstractMapTools.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Double) {
            return (Double)answer;
        }
        return new Double(answer.doubleValue());
    }

    public static Map getMap(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null && answer instanceof Map) {
            return (Map)answer;
        }
        return null;
    }

    public static Object getObject(Map map, Object key, Object defaultValue) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            return answer;
        }
        return defaultValue;
    }

    public static String getString(Map map, Object key, String defaultValue) {
        String answer = AbstractMapTools.getString(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Boolean getBoolean(Map map, Object key, Boolean defaultValue) {
        Boolean answer = AbstractMapTools.getBoolean(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Number getNumber(Map map, Object key, Number defaultValue) {
        Number answer = AbstractMapTools.getNumber(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Byte getByte(Map map, Object key, Byte defaultValue) {
        Byte answer = AbstractMapTools.getByte(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Short getShort(Map map, Object key, Short defaultValue) {
        Short answer = AbstractMapTools.getShort(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Integer getInteger(Map map, Object key, Integer defaultValue) {
        Integer answer = AbstractMapTools.getInteger(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Long getLong(Map map, Object key, Long defaultValue) {
        Long answer = AbstractMapTools.getLong(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Float getFloat(Map map, Object key, Float defaultValue) {
        Float answer = AbstractMapTools.getFloat(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Double getDouble(Map map, Object key, Double defaultValue) {
        Double answer = AbstractMapTools.getDouble(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Map getMap(Map map, Object key, Map defaultValue) {
        Map answer = AbstractMapTools.getMap(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static boolean getBooleanValue(Map map, Object key) {
        Boolean booleanObject = AbstractMapTools.getBoolean(map, key);
        if (booleanObject == null) {
            return false;
        }
        return booleanObject;
    }

    public static byte getByteValue(Map map, Object key) {
        Byte byteObject = AbstractMapTools.getByte(map, key);
        if (byteObject == null) {
            return 0;
        }
        return byteObject;
    }

    public static short getShortValue(Map map, Object key) {
        Short shortObject = AbstractMapTools.getShort(map, key);
        if (shortObject == null) {
            return 0;
        }
        return shortObject;
    }

    public static int getIntValue(Map map, Object key) {
        Integer integerObject = AbstractMapTools.getInteger(map, key);
        if (integerObject == null) {
            return 0;
        }
        return integerObject;
    }

    public static long getLongValue(Map map, Object key) {
        Long longObject = AbstractMapTools.getLong(map, key);
        if (longObject == null) {
            return 0L;
        }
        return longObject;
    }

    public static float getFloatValue(Map map, Object key) {
        Float floatObject = AbstractMapTools.getFloat(map, key);
        if (floatObject == null) {
            return 0.0f;
        }
        return floatObject.floatValue();
    }

    public static double getDoubleValue(Map map, Object key) {
        Double doubleObject = AbstractMapTools.getDouble(map, key);
        if (doubleObject == null) {
            return 0.0;
        }
        return doubleObject;
    }

    public static boolean getBooleanValue(Map map, Object key, boolean defaultValue) {
        Boolean booleanObject = AbstractMapTools.getBoolean(map, key);
        if (booleanObject == null) {
            return defaultValue;
        }
        return booleanObject;
    }

    public static byte getByteValue(Map map, Object key, byte defaultValue) {
        Byte byteObject = AbstractMapTools.getByte(map, key);
        if (byteObject == null) {
            return defaultValue;
        }
        return byteObject;
    }

    public static short getShortValue(Map map, Object key, short defaultValue) {
        Short shortObject = AbstractMapTools.getShort(map, key);
        if (shortObject == null) {
            return defaultValue;
        }
        return shortObject;
    }

    public static int getIntValue(Map map, Object key, int defaultValue) {
        Integer integerObject = AbstractMapTools.getInteger(map, key);
        if (integerObject == null) {
            return defaultValue;
        }
        return integerObject;
    }

    public static long getLongValue(Map map, Object key, long defaultValue) {
        Long longObject = AbstractMapTools.getLong(map, key);
        if (longObject == null) {
            return defaultValue;
        }
        return longObject;
    }

    public static float getFloatValue(Map map, Object key, float defaultValue) {
        Float floatObject = AbstractMapTools.getFloat(map, key);
        if (floatObject == null) {
            return defaultValue;
        }
        return floatObject.floatValue();
    }

    public static double getDoubleValue(Map map, Object key, double defaultValue) {
        Double doubleObject = AbstractMapTools.getDouble(map, key);
        if (doubleObject == null) {
            return defaultValue;
        }
        return doubleObject;
    }

    public static Properties toProperties(Map map) {
        Properties answer = new Properties();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                answer.put(key, value);
            }
        }
        return answer;
    }

    public static Map toMap(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            Object value = resourceBundle.getObject(key);
            map.put(key, value);
        }
        return map;
    }

    protected static void logInfo(Exception ex) {
        System.out.println("INFO: Exception: " + ex);
    }

    public static Map invertMap(Map map) {
        HashMap out = new HashMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            out.put(entry.getValue(), entry.getKey());
        }
        return out;
    }

    public static void safeAddToMap(Map map, Object key, Object value) throws NullPointerException {
        if (value == null) {
            map.put(key, "");
        } else {
            map.put(key, value);
        }
    }

    public static Map putAll(Map map, Object[] array) {
        map.size();
        if (array == null || array.length == 0) {
            return map;
        }
        Object obj = array[0];
        if (obj instanceof Map.Entry) {
            for (int i = 0; i < array.length; ++i) {
                Map.Entry entry = (Map.Entry)array[i];
                map.put(entry.getKey(), entry.getValue());
            }
        } else if (obj instanceof Object[]) {
            for (int i = 0; i < array.length; ++i) {
                Object[] sub = (Object[])array[i];
                if (sub == null || sub.length < 2) {
                    throw new IllegalArgumentException("Invalid array element: " + i);
                }
                map.put(sub[0], sub[1]);
            }
        } else {
            int i = 0;
            while (i < array.length - 1) {
                map.put(array[i++], array[i++]);
            }
        }
        return map;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map map) {
        return !AbstractMapTools.isEmpty(map);
    }

    public static Map synchronizedMap(Map map) {
        return Collections.synchronizedMap(map);
    }

    public static Map synchronizedSortedMap(SortedMap map) {
        return Collections.synchronizedSortedMap(map);
    }
}

