/*
 * Decompiled with CFR 0.152.
 */
package com.jz.aliyun.tools;

import com.aliyun.oss.OSSClient;
import com.jz.aliyun.beans.AliyunConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssTools {
    private static final Logger logger = LoggerFactory.getLogger(OssTools.class);
    private AliyunConfig aliyunConfig;

    private OssTools() {
    }

    private OssTools(AliyunConfig aliyunConfig) {
        this.aliyunConfig = aliyunConfig;
    }

    public static OssTools getInstance(AliyunConfig aliyunConfig) {
        return new OssTools(aliyunConfig);
    }

    public void upload(String localFilePath, String ossFilePath) throws FileNotFoundException {
        logger.info("aliyun upload file : {} => {}", (Object)localFilePath, (Object)ossFilePath);
        this.upload(new FileInputStream(new File(localFilePath)), ossFilePath);
    }

    private OSSClient getOssClient() {
        return new OSSClient(this.aliyunConfig.getEndpoint(), this.aliyunConfig.getAccessKeyId(), this.aliyunConfig.getAccessKeySecret());
    }

    public void upload(InputStream inputStream, String ossFilePath) throws FileNotFoundException {
        OSSClient ossClient = this.getOssClient();
        ossClient.putObject(this.aliyunConfig.getBucketName(), ossFilePath, inputStream);
        ossClient.shutdown();
    }

    public void copy(String sourcePath, String destinationPath) throws FileNotFoundException {
        logger.info("aliyun copy file : {} => {}", (Object)sourcePath, (Object)destinationPath);
        OSSClient ossClient = this.getOssClient();
        ossClient.copyObject(this.aliyunConfig.getBucketName(), sourcePath, this.aliyunConfig.getBucketName(), destinationPath);
        ossClient.shutdown();
    }
}

