/*
 * Decompiled with CFR 0.152.
 */
package com.jz.aliyun.tools;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class CDNTools {
    private static final String CHARSET_UTF8 = "utf8";
    private static final String ALGORITHM = "UTF-8";
    private static final String SEPARATOR = "&";

    private static String generateSign(String method, Map<String, String> parameter, String accessKeySecret) throws Exception {
        String signString = CDNTools.generateSignString(method, parameter);
        byte[] signBytes = CDNTools.hmacSHA1Signature(accessKeySecret + SEPARATOR, signString);
        String signature = CDNTools.newStringByBase64(signBytes);
        if ("POST".equals(method)) {
            return signature;
        }
        return URLEncoder.encode(signature, ALGORITHM);
    }

    private static String generateSignString(String httpMethod, Map<String, String> parameter) throws IOException {
        TreeMap<String, String> sortParameter = new TreeMap<String, String>();
        sortParameter.putAll(parameter);
        String canonicalizedQueryString = CDNTools.generateQueryString(sortParameter, true);
        if (null == httpMethod) {
            throw new RuntimeException("httpMethod can not be empty");
        }
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(httpMethod).append(SEPARATOR);
        stringToSign.append(CDNTools.percentEncode("/")).append(SEPARATOR);
        stringToSign.append(CDNTools.percentEncode(canonicalizedQueryString));
        return stringToSign.toString();
    }

    private static String generateQueryString(Map<String, String> params, boolean isEncodeKV) {
        StringBuilder canonicalizedQueryString = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (isEncodeKV) {
                canonicalizedQueryString.append(CDNTools.percentEncode(entry.getKey())).append("=").append(CDNTools.percentEncode(entry.getValue())).append(SEPARATOR);
                continue;
            }
            canonicalizedQueryString.append(entry.getKey()).append("=").append(entry.getValue()).append(SEPARATOR);
        }
        if (canonicalizedQueryString.length() > 1) {
            canonicalizedQueryString.setLength(canonicalizedQueryString.length() - 1);
        }
        return canonicalizedQueryString.toString();
    }

    private static String percentEncode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLEncoder.encode(value, CHARSET_UTF8).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static byte[] hmacSHA1Signature(String secret, String baseString) throws Exception {
        if (StringUtils.isEmpty((CharSequence)secret)) {
            throw new IOException("secret can not be empty");
        }
        if (StringUtils.isEmpty((CharSequence)baseString)) {
            return null;
        }
        Mac mac = Mac.getInstance("HmacSHA1");
        SecretKeySpec keySpec = new SecretKeySpec(secret.getBytes(CHARSET_UTF8), ALGORITHM);
        mac.init(keySpec);
        return mac.doFinal(baseString.getBytes(CHARSET_UTF8));
    }

    private static String newStringByBase64(byte[] bytes) throws UnsupportedEncodingException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])bytes, (boolean)false), CHARSET_UTF8);
    }

    private static String getFormatIso8601Date() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(System.currentTimeMillis());
    }

    public static boolean refreshCdnCache(String path) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("AccessKeyId", "uWGXpQpR67msNVlE");
        param.put("Format", "JSON");
        param.put("Version", "2014-11-11");
        param.put("SignatureMethod", "HMAC-SHA1");
        param.put("SignatureVersion", "1.0");
        param.put("SignatureNonce", StringTools.RandomString.random((int)64));
        param.put("Timestamp", CDNTools.getFormatIso8601Date());
        param.put("Action", "RefreshObjectCaches");
        param.put("ObjectPath", path);
        param.put("ObjectType", "File");
        param.put("Signature", CDNTools.generateSign("POST", param, "Nv5KkfhKqbMXB0yfHipxwM8mcGYAiZ"));
        String result = ConnectPost.send((String)"https://cdn.aliyuncs.com", param, (String)ALGORITHM);
        if (StringTools.isEmpty((CharSequence)result)) {
            return false;
        }
        Map has = (Map)GsonTools.gson.fromJson(result, Map.class);
        return ArrayMapTools.containsKeys((Map)has, (String[])new String[]{"RefreshTaskId", "RequestId"});
    }
}

