/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tomatoart.poster;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.annotation.IntRange;
import android.text.Html;
import android.text.Spanned;
import android.view.View;
import com.gymchina.library.autosize.DimensPTKt;
import com.gymchina.library.common.utils.ActivityUtil;
import com.gymchina.library.imageloader.ImageLoaderKt;
import com.gymchina.tomatoart.poster.PosterCache;
import com.gymchina.tomatoart.poster.entity.PosterPhoto;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/gymchina/tomatoart/poster/PosterUtils;", "", "()V", "Companion", "poster_release"})
public final class PosterUtils {
    private static final double ptPxScale;
    public static final Companion Companion;

    private PosterUtils() {
        throw (Throwable)new Error("\u4e0d\u80fd\u521d\u59cb\u5316\u8be5\u7c7b");
    }

    static {
        Companion = new Companion(null);
        ptPxScale = (double)DimensPTKt.getPt100() / (double)100;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001eJ\u0016\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001eJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0018\u0010&\u001a\u0004\u0018\u00010#2\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006)"}, d2={"Lcom/gymchina/tomatoart/poster/PosterUtils$Companion;", "", "()V", "ptPxScale", "", "getPtPxScale", "()D", "fileToUri", "Landroid/net/Uri;", "file", "Ljava/io/File;", "forHtmlRemoveWhiteSpace", "", "content", "", "getHtmlWithOmitByContent", "length", "", "insertSystemAlbum", "", "ctx", "Landroid/content/Context;", "posterPhotoToUri", "posterPhoto", "Lcom/gymchina/tomatoart/poster/entity/PosterPhoto;", "saveBitmapForPosterPhoto", "", "syncLoadBitmapForPosterPhoto", "syncLoadBitmapForPosterPhotos", "list", "", "updateSystemAlbum", "urlsToPosterPhoto", "urls", "viewToBitmap", "Landroid/graphics/Bitmap;", "view", "Landroid/view/View;", "zoomBitmap", "bitmap", "newWidth", "poster_release"})
    public static final class Companion {
        public final double getPtPxScale() {
            return ptPxScale;
        }

        public final void saveBitmapForPosterPhoto(@NotNull PosterPhoto posterPhoto) {
            Bitmap bitmap;
            Intrinsics.checkParameterIsNotNull((Object)posterPhoto, (String)"posterPhoto");
            File file = posterPhoto.getCacheFile();
            if (!(file != null && file.exists() && file.isFile() || (bitmap = posterPhoto.getBitmap()) == null)) {
                posterPhoto.setCacheFile(PosterCache.Companion.saveBitmap(bitmap));
            }
        }

        public final void syncLoadBitmapForPosterPhotos(@NotNull Context ctx, @NotNull List<PosterPhoto> list) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull(list, (String)"list");
            Context $receiver$iv = ctx;
            if (ActivityUtil.Companion.ctxFinished($receiver$iv)) {
                return;
            }
            for (PosterPhoto posterPhoto : list) {
                this.syncLoadBitmapForPosterPhoto(ctx, posterPhoto);
            }
        }

        public final void syncLoadBitmapForPosterPhoto(@NotNull Context ctx, @NotNull PosterPhoto posterPhoto) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)posterPhoto, (String)"posterPhoto");
            Context $receiver$iv = ctx;
            if (ActivityUtil.Companion.ctxFinished($receiver$iv)) {
                return;
            }
            if (posterPhoto.getBitmap() != null) {
                return;
            }
            String url = posterPhoto.getUrl();
            CharSequence charSequence = url;
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                posterPhoto.setBitmap(ImageLoaderKt.syncLoadBitmap((Context)ctx, (String)url));
            }
        }

        @NotNull
        public final String getHtmlWithOmitByContent(@NotNull String content, @IntRange(from=1L) int length) {
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            if (content.length() <= length) {
                string2 = content;
            } else {
                String string3 = content;
                int n = 0;
                int n2 = length - 1;
                StringBuilder stringBuilder = new StringBuilder().append("<p>");
                boolean bl = false;
                String string4 = string3.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string5 = string4;
                string2 = stringBuilder.append(string5).append("&#8230;</p>").toString();
            }
            return string2;
        }

        @NotNull
        public final CharSequence forHtmlRemoveWhiteSpace(@NotNull String content) {
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Spanned spanned = Html.fromHtml((String)content);
            StringBuilder builder = new StringBuilder();
            Spanned spanned2 = spanned;
            for (int i = 0; i < spanned2.length(); ++i) {
                char c = spanned2.charAt(i);
                if (Character.isWhitespace(c)) continue;
                builder.append(c);
            }
            return builder;
        }

        @Nullable
        public final Uri posterPhotoToUri(@NotNull PosterPhoto posterPhoto) {
            Intrinsics.checkParameterIsNotNull((Object)posterPhoto, (String)"posterPhoto");
            File file = posterPhoto.getCacheFile();
            return file != null ? this.fileToUri(file) : null;
        }

        @NotNull
        public final Uri fileToUri(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Uri uri = Uri.fromFile((File)file);
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(file)");
            return uri;
        }

        @NotNull
        public final List<PosterPhoto> urlsToPosterPhoto(@NotNull List<String> urls) {
            Intrinsics.checkParameterIsNotNull(urls, (String)"urls");
            boolean bl = false;
            List result = new ArrayList();
            for (String url : urls) {
                result.add(new PosterPhoto(url, null, null, null, 14, null));
            }
            return result;
        }

        @NotNull
        public final Bitmap viewToBitmap(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawColor(-1);
            view.draw(canvas);
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
            return bitmap2;
        }

        @Nullable
        public final Bitmap zoomBitmap(@NotNull Bitmap bitmap, int newWidth) {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix matrix = new Matrix();
            float scaleWidth = (float)newWidth / (float)width;
            matrix.postScale(scaleWidth, scaleWidth);
            Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            if (Intrinsics.areEqual((Object)bitmap, (Object)newBitmap) ^ true && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            return newBitmap;
        }

        public final boolean insertSystemAlbum(@NotNull Context ctx, @NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            try {
                MediaStore.Images.Media.insertImage((ContentResolver)ctx.getContentResolver(), (String)file.getAbsolutePath(), (String)file.getName(), null);
                this.updateSystemAlbum(ctx, file);
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }

        public final void updateSystemAlbum(@NotNull Context ctx, @NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            ctx.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

